"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogSourceConfigurationFormState = void 0;
var _react = require("react");
var _form_elements = require("./form_elements");
var _indices_configuration_form_state = require("./indices_configuration_form_state");
var _log_columns_configuration_form_state = require("./log_columns_configuration_form_state");
var _name_configuration_form_state = require("./name_configuration_form_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogSourceConfigurationFormState = logViewAttributes => {
  var _logViewAttributes$na;
  const nameFormElement = (0, _name_configuration_form_state.useNameFormElement)((_logViewAttributes$na = logViewAttributes === null || logViewAttributes === void 0 ? void 0 : logViewAttributes.name) !== null && _logViewAttributes$na !== void 0 ? _logViewAttributes$na : '');
  const logIndicesFormElement = (0, _indices_configuration_form_state.useLogIndicesFormElement)((0, _react.useMemo)(() => {
    var _logViewAttributes$lo;
    return (_logViewAttributes$lo = logViewAttributes === null || logViewAttributes === void 0 ? void 0 : logViewAttributes.logIndices) !== null && _logViewAttributes$lo !== void 0 ? _logViewAttributes$lo : {
      type: 'index_name',
      indexName: ''
    };
  }, [logViewAttributes]));
  const logColumnsFormElement = (0, _log_columns_configuration_form_state.useLogColumnsFormElement)((0, _react.useMemo)(() => {
    var _logViewAttributes$lo2;
    return (_logViewAttributes$lo2 = logViewAttributes === null || logViewAttributes === void 0 ? void 0 : logViewAttributes.logColumns) !== null && _logViewAttributes$lo2 !== void 0 ? _logViewAttributes$lo2 : [];
  }, [logViewAttributes]));
  const sourceConfigurationFormElement = (0, _form_elements.useCompositeFormElement)((0, _react.useMemo)(() => ({
    childFormElements: {
      name: nameFormElement,
      logIndices: logIndicesFormElement,
      logColumns: logColumnsFormElement
    },
    validate: async () => []
  }), [nameFormElement, logIndicesFormElement, logColumnsFormElement]));
  return {
    formState: sourceConfigurationFormElement.value,
    logIndicesFormElement,
    logColumnsFormElement,
    nameFormElement,
    sourceConfigurationFormElement
  };
};
exports.useLogSourceConfigurationFormState = useLogSourceConfigurationFormState;