"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineLogViewCallout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InlineLogViewCallout = ({
  revertToDefaultLogView
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: _i18n.i18n.translate('xpack.infra.logs.settings.inlineLogViewCalloutTitle', {
      defaultMessage: 'Inline Log View in use'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.infra.logs.settings.inlineLogViewCalloutDescription', {
    defaultMessage: 'An inline Log View is currently being used, changes will be synchronized to the URL, but they will not be persisted.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraInlineLogViewCalloutRevertToDefaultPersistedLogViewButton",
    fullWidth: false,
    fill: true,
    onClick: revertToDefaultLogView
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.settings.inlineLogViewCalloutButtonText",
    defaultMessage: "Revert to default (persisted) Log View"
  }))));
};
exports.InlineLogViewCallout = InlineLogViewCallout;