"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryRatePageContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _public = require("@kbn/logs-shared-plugin/public");
var _log_analysis = require("../../../../common/log_analysis");
var _loading_page = require("../../../components/loading_page");
var _log_analysis_setup = require("../../../components/logging/log_analysis_setup");
var _setup_flyout = require("../../../components/logging/log_analysis_setup/setup_flyout");
var _subscription_splash_content = require("../../../components/subscription_splash_content");
var _log_analysis2 = require("../../../containers/logs/log_analysis");
var _log_entry_categories = require("../../../containers/logs/log_analysis/modules/log_entry_categories");
var _log_entry_rate = require("../../../containers/logs/log_analysis/modules/log_entry_rate");
var _page_template = require("../shared/page_template");
var _page_results_content = require("./page_results_content");
var _page_setup_content = require("./page_setup_content");
var _use_log_ml_job_id_formats_shim = require("../shared/use_log_ml_job_id_formats_shim");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JOB_STATUS_POLLING_INTERVAL = 30000;
const anomaliesTitle = _i18n.i18n.translate('xpack.infra.logs.anomaliesPageTitle', {
  defaultMessage: 'Anomalies'
});
const LogEntryRatePageContent = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    hasLogAnalysisCapabilites,
    hasLogAnalysisReadCapabilities,
    hasLogAnalysisSetupCapabilities
  } = (0, _log_analysis2.useLogAnalysisCapabilitiesContext)();
  const {
    fetchJobStatus: fetchLogEntryCategoriesJobStatus,
    fetchModuleDefinition: fetchLogEntryCategoriesModuleDefinition,
    jobStatus: logEntryCategoriesJobStatus,
    setupStatus: logEntryCategoriesSetupStatus
  } = (0, _log_entry_categories.useLogEntryCategoriesModuleContext)();
  const {
    fetchJobStatus: fetchLogEntryRateJobStatus,
    fetchModuleDefinition: fetchLogEntryRateModuleDefinition,
    jobStatus: logEntryRateJobStatus,
    setupStatus: logEntryRateSetupStatus
  } = (0, _log_entry_rate.useLogEntryRateModuleContext)();
  const {
    showModuleList
  } = (0, _setup_flyout.useLogAnalysisSetupFlyoutStateContext)();
  const fetchAllJobStatuses = (0, _react.useCallback)(() => Promise.all([fetchLogEntryCategoriesJobStatus(), fetchLogEntryRateJobStatus()]), [fetchLogEntryCategoriesJobStatus, fetchLogEntryRateJobStatus]);
  (0, _react.useEffect)(() => {
    if (hasLogAnalysisReadCapabilities) {
      fetchAllJobStatuses();
    }
  }, [fetchAllJobStatuses, hasLogAnalysisReadCapabilities]);
  (0, _react.useEffect)(() => {
    if (hasLogAnalysisReadCapabilities) {
      fetchLogEntryCategoriesModuleDefinition();
    }
  }, [fetchLogEntryCategoriesModuleDefinition, hasLogAnalysisReadCapabilities]);
  (0, _react.useEffect)(() => {
    if (hasLogAnalysisReadCapabilities) {
      fetchLogEntryRateModuleDefinition();
    }
  }, [fetchLogEntryRateModuleDefinition, hasLogAnalysisReadCapabilities]);
  (0, _useInterval.default)(() => {
    if (logEntryCategoriesSetupStatus.type !== 'pending' && hasLogAnalysisReadCapabilities) {
      fetchLogEntryCategoriesJobStatus();
    }
    if (logEntryRateSetupStatus.type !== 'pending' && hasLogAnalysisReadCapabilities) {
      fetchLogEntryRateJobStatus();
    }
  }, JOB_STATUS_POLLING_INTERVAL);
  const {
    idFormats
  } = (0, _use_log_ml_job_id_formats_shim.useLogMlJobIdFormatsShimContext)();
  if (!hasLogAnalysisCapabilites) {
    return /*#__PURE__*/_react.default.createElement(_subscription_splash_content.SubscriptionSplashPage, {
      "data-test-subj": "logsLogEntryRatePage",
      pageHeader: {
        pageTitle: anomaliesTitle
      }
    });
  } else if (!hasLogAnalysisReadCapabilities) {
    return /*#__PURE__*/_react.default.createElement(AnomaliesPageTemplate, {
      isEmptyState: true
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingResultsPrivilegesPrompt, null));
  } else if (logEntryCategoriesSetupStatus.type === 'initializing' || logEntryRateSetupStatus.type === 'initializing') {
    return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPage, {
      message: _i18n.i18n.translate('xpack.infra.logs.analysisPage.loadingMessage', {
        defaultMessage: 'Checking status of analysis jobs...'
      })
    });
  } else if (logEntryCategoriesSetupStatus.type === 'unknown' || logEntryRateSetupStatus.type === 'unknown') {
    return /*#__PURE__*/_react.default.createElement(AnomaliesPageTemplate, {
      isEmptyState: true
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.LogAnalysisSetupStatusUnknownPrompt, {
      retry: fetchAllJobStatuses
    }));
  } else if ((0, _log_analysis.isJobStatusWithResults)(logEntryCategoriesJobStatus[_log_analysis.logEntryCategoriesJobType]) || (0, _log_analysis.isJobStatusWithResults)(logEntryRateJobStatus[_log_analysis.logEntryRateJobType])) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_results_content.LogEntryRateResultsContent, {
      idFormats: idFormats,
      pageTitle: anomaliesTitle
    }), /*#__PURE__*/_react.default.createElement(_setup_flyout.LogAnalysisSetupFlyout, null));
  } else if (!hasLogAnalysisSetupCapabilities) {
    return /*#__PURE__*/_react.default.createElement(AnomaliesPageTemplate, {
      isEmptyState: true
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingSetupPrivilegesPrompt, null), ";");
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AnomaliesPageTemplate, {
      isEmptyState: true
    }, /*#__PURE__*/_react.default.createElement(_page_setup_content.LogEntryRateSetupContent, {
      onOpenSetup: showModuleList
    })), /*#__PURE__*/_react.default.createElement(_setup_flyout.LogAnalysisSetupFlyout, null));
  }
});
exports.LogEntryRatePageContent = LogEntryRatePageContent;
const AnomaliesPageTemplate = ({
  children,
  ...rest
}) => {
  const {
    logViewStatus
  } = (0, _public.useLogViewContext)();
  return /*#__PURE__*/_react.default.createElement(_page_template.LogsPageTemplate, (0, _extends2.default)({
    hasData: (logViewStatus === null || logViewStatus === void 0 ? void 0 : logViewStatus.index) !== 'missing',
    "data-test-subj": "logsLogEntryRatePage",
    pageHeader: rest.isEmptyState ? undefined : {
      pageTitle: anomaliesTitle
    }
  }, rest), children);
};