"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogViewReference = void 0;
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _uuid = require("uuid");
var _common = require("@kbn/logs-shared-plugin/common");
var _react = require("react");
var _use_lazy_ref = require("./use_lazy_ref");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogViewReference = ({
  id,
  extraFields = []
}) => {
  const {
    services: {
      logsShared
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    loading,
    value: defaultLogView
  } = (0, _useAsync.default)(() => logsShared.logViews.client.getLogView(_common.DEFAULT_LOG_VIEW), []);
  const logViewReference = (0, _use_lazy_ref.useLazyRef)(() => {
    return !defaultLogView ? null : {
      type: 'log-view-inline',
      id,
      attributes: {
        name: 'Hosts Logs View',
        description: 'Default view for hosts logs tab',
        logIndices: defaultLogView.attributes.logIndices,
        logColumns: [{
          timestampColumn: {
            id: '5e7f964a-be8a-40d8-88d2-fbcfbdca0e2f'
          }
        }, ...extraFields.map(fieldName => ({
          fieldColumn: {
            id: (0, _uuid.v4)(),
            field: fieldName
          }
        })), {
          messageColumn: {
            id: 'b645d6da-824b-4723-9a2a-e8cece1645c0'
          }
        }]
      }
    };
  });
  const getLogsDataView = (0, _react.useCallback)(async reference => {
    if (reference) {
      const resolvedLogview = await logsShared.logViews.client.getResolvedLogView(reference);
      return resolvedLogview.dataViewReference;
    }
  }, [logsShared.logViews.client]);
  return {
    logViewReference: logViewReference.current,
    loading,
    getLogsDataView
  };
};
exports.useLogViewReference = useLogViewReference;