"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensAttributes = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _lensEmbeddableUtils = require("@kbn/lens-embeddable-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLensAttributes = ({
  dataView,
  ...params
}) => {
  const {
    services: {
      lens
    }
  } = (0, _public.useKibana)();
  const {
    navigateToPrefilledEditor
  } = lens;
  const {
    value,
    error
  } = (0, _useAsync.default)(() => {
    return lens.stateHelperApi();
  }, [lens]);
  const {
    formula: formulaAPI
  } = value !== null && value !== void 0 ? value : {};
  const attributes = (0, _react.useMemo)(() => {
    if (!dataView || !formulaAPI) {
      return null;
    }
    const builder = new _lensEmbeddableUtils.LensAttributesBuilder({
      visualization: chartFactory({
        dataView,
        formulaAPI,
        ...params
      })
    });
    return builder.build();
  }, [dataView, formulaAPI, params]);
  const injectFilters = (0, _react.useCallback)(({
    filters,
    query
  }) => {
    if (!attributes) {
      return null;
    }
    return {
      ...attributes,
      state: {
        ...attributes.state,
        query,
        filters: [...attributes.state.filters, ...filters]
      }
    };
  }, [attributes]);
  const openInLensAction = (0, _react.useCallback)(({
    timeRange,
    query,
    filters,
    searchSessionId
  }) => () => {
    const injectedAttributes = injectFilters({
      filters,
      query
    });
    if (injectedAttributes) {
      navigateToPrefilledEditor({
        id: '',
        timeRange,
        attributes: injectedAttributes,
        searchSessionId
      }, {
        openInNewTab: true
      });
    }
  }, [injectFilters, navigateToPrefilledEditor]);
  const getExtraActions = (0, _react.useCallback)(({
    timeRange,
    filters = [],
    query = {
      language: 'kuery',
      query: ''
    },
    searchSessionId
  }) => {
    const openInLens = getOpenInLensAction(openInLensAction({
      timeRange,
      filters,
      query,
      searchSessionId
    }));
    return [openInLens];
  }, [openInLensAction]);
  const getFormula = () => {
    const firstDataLayer = [...(Array.isArray(params.layers) ? params.layers : [params.layers])].find(p => p.layerType === 'data');
    if (!firstDataLayer) {
      return '';
    }
    const mainFormulaConfig = Array.isArray(firstDataLayer.data) ? firstDataLayer.data[0] : firstDataLayer.data;
    return mainFormulaConfig.value;
  };
  return {
    formula: getFormula(),
    attributes,
    getExtraActions,
    error
  };
};
exports.useLensAttributes = useLensAttributes;
const chartFactory = ({
  dataView,
  formulaAPI,
  ...params
}) => {
  switch (params.visualizationType) {
    case 'lnsXY':
      if (!Array.isArray(params.layers)) {
        throw new Error(`Invalid layers type. Expected an array of layers.`);
      }
      const xyLayerFactory = layer => {
        switch (layer.layerType) {
          case 'data':
            {
              return new _lensEmbeddableUtils.XYDataLayer(layer);
            }
          case 'referenceLine':
            {
              return new _lensEmbeddableUtils.XYReferenceLinesLayer(layer);
            }
          default:
            throw new Error(`Invalid layer type`);
        }
      };
      const {
        layers,
        ...rest
      } = params;
      return new _lensEmbeddableUtils.XYChart({
        dataView,
        formulaAPI,
        layers: layers.map(layerItem => {
          return xyLayerFactory(layerItem);
        }),
        ...rest
      });
    case 'lnsMetric':
      if (Array.isArray(params.layers)) {
        throw new Error(`Invalid layer type. Expected a single layer object.`);
      }
      return new _lensEmbeddableUtils.MetricChart({
        dataView,
        formulaAPI,
        layers: new _lensEmbeddableUtils.MetricLayer({
          data: params.layers.data,
          options: {
            ...params.layers.options
          },
          layerType: params.layers.layerType
        }),
        title: params.title
      });
    default:
      throw new Error(`Unsupported chart type`);
  }
};
const getOpenInLensAction = onExecute => {
  return {
    id: 'openInLens',
    getDisplayName(_context) {
      return _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.actions.openInLines', {
        defaultMessage: 'Open in Lens'
      });
    },
    getIconType(_context) {
      return 'visArea';
    },
    type: 'actionButton',
    async isCompatible(_context) {
      return true;
    },
    async execute(_context) {
      onExecute();
    },
    order: 100
  };
};