"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaHeader = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKibanaHeader = () => {
  const actionMenuHeight = (0, _react.useMemo)(() => {
    var _actionMenu$getBoundi;
    // only in serverless
    const actionMenu = document.querySelector(`[data-test-subj="kibanaProjectHeaderActionMenu"]`);
    return (_actionMenu$getBoundi = actionMenu === null || actionMenu === void 0 ? void 0 : actionMenu.getBoundingClientRect().height) !== null && _actionMenu$getBoundi !== void 0 ? _actionMenu$getBoundi : 0;
  }, []);
  return {
    actionMenuHeight
  };
};
exports.useKibanaHeader = useKibanaHeader;