"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToUrlState = exports.WithMetricsExplorerOptionsUrlState = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _react = _interopRequireWildcard(require("react"));
var _ThrowReporter = require("io-ts/lib/ThrowReporter");
var _url_state = require("../../utils/url_state");
var _use_metrics_explorer_options = require("../../pages/metrics/metrics_explorer/hooks/use_metrics_explorer_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WithMetricsExplorerOptionsUrlState = () => {
  const {
    options,
    chartOptions,
    setChartOptions,
    timeRange,
    setOptions: setRawOptions,
    setTimeRange
  } = (0, _use_metrics_explorer_options.useMetricsExplorerOptionsContainerContext)();
  const setOptions = value => {
    setRawOptions(value);
  };
  const urlState = (0, _react.useMemo)(() => ({
    options,
    chartOptions,
    timerange: timeRange
  }), [options, chartOptions, timeRange]);
  const handleChange = newUrlState => {
    if (newUrlState && newUrlState.options) {
      setOptions(newUrlState.options);
    }
    if (newUrlState && newUrlState.timerange) {
      setTimeRange(newUrlState.timerange);
    }
    if (newUrlState && newUrlState.chartOptions) {
      setChartOptions(newUrlState.chartOptions);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_url_state.UrlStateContainer, {
    urlState: urlState,
    urlStateKey: "metricsExplorer",
    mapToUrlState: mapToUrlState,
    onChange: handleChange,
    onInitialize: handleChange,
    populateWithInitialState: true
  });
};
exports.WithMetricsExplorerOptionsUrlState = WithMetricsExplorerOptionsUrlState;
function isMetricExplorerOptions(subject) {
  const result = _use_metrics_explorer_options.metricsExplorerOptionsRT.decode(subject);
  try {
    _ThrowReporter.ThrowReporter.report(result);
    return true;
  } catch (e) {
    return false;
  }
}
function isMetricExplorerChartOptions(subject) {
  const result = _use_metrics_explorer_options.metricsExplorerChartOptionsRT.decode(subject);
  try {
    _ThrowReporter.ThrowReporter.report(result);
    return true;
  } catch (e) {
    return false;
  }
}
function isMetricExplorerTimeOption(subject) {
  const result = _use_metrics_explorer_options.metricsExplorerTimeOptionsRT.decode(subject);
  try {
    _ThrowReporter.ThrowReporter.report(result);
    return true;
  } catch (e) {
    return false;
  }
}
const mapToUrlState = value => {
  const finalState = {};
  if (value) {
    if (value.options && isMetricExplorerOptions(value.options)) {
      value.options.source = 'url';
      (0, _saferLodashSet.set)(finalState, 'options', value.options);
    }
    if (value.timerange && isMetricExplorerTimeOption(value.timerange)) {
      (0, _saferLodashSet.set)(finalState, 'timerange', value.timerange);
    }
    if (value.chartOptions && isMetricExplorerChartOptions(value.chartOptions)) {
      (0, _saferLodashSet.set)(finalState, 'chartOptions', value.chartOptions);
    }
    return finalState;
  }
};
exports.mapToUrlState = mapToUrlState;