"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpsertViewModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nameLabel = _i18n.i18n.translate('xpack.infra.waffle.savedViews.viewNamePlaceholder', {
  defaultMessage: 'Name'
});
const UpsertViewModal = ({
  onClose,
  onSave,
  isSaving,
  initialName = '',
  initialIncludeTime = false,
  title
}) => {
  const [viewName, setViewName] = (0, _react.useState)(initialName);
  const [shouldIncludeTime, setIncludeTime] = (0, _react.useState)(initialIncludeTime);
  const trimmedName = viewName.trim();
  const handleNameChange = e => {
    setViewName(e.target.value);
  };
  const handleTimeCheckChange = e => {
    setIncludeTime(e.target.checked);
  };
  const saveView = () => {
    onSave(trimmedName, shouldIncludeTime);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "data-test-subj": "savedViews-upsertModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: nameLabel,
    "data-test-subj": "savedViewName",
    value: viewName,
    onChange: handleNameChange,
    "aria-label": nameLabel
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: 'saved-view-save-time-checkbox',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Store time with view",
      id: "xpack.infra.waffle.savedViews.includeTimeFilterLabel"
    }),
    checked: shouldIncludeTime,
    onChange: handleTimeCheckChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    grow: false,
    style: {
      maxWidth: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "This changes the time filter to the currently selected time each time the view is loaded",
    id: "xpack.infra.waffle.savedViews.includeTimeHelpText"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraSavedViewCreateModalCancelButton",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Cancel",
    id: "xpack.infra.waffle.savedViews.cancelButton"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: trimmedName.length === 0,
    fill: true,
    isLoading: isSaving,
    onClick: saveView,
    "data-test-subj": "createSavedViewButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Save",
    id: "xpack.infra.waffle.savedViews.saveButton"
  }))));
};
exports.UpsertViewModal = UpsertViewModal;