"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSetupDatasetFilter = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_visibility_state = require("../../../../utils/use_visibility_state");
var _quality_warning_notices = require("../../log_analysis_job_status/quality_warning_notices");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexSetupDatasetFilter = ({
  availableDatasets,
  datasetFilter,
  isDisabled,
  onChangeDatasetFilter
}) => {
  const {
    isVisible,
    hide,
    show
  } = (0, _use_visibility_state.useVisibilityState)(false);
  const changeDatasetFilter = (0, _react.useCallback)(options => {
    const selectedDatasets = options.filter(({
      checked
    }) => checked === 'on').map(({
      label
    }) => label);
    onChangeDatasetFilter(selectedDatasets.length === 0 ? {
      type: 'includeAll'
    } : {
      type: 'includeSome',
      datasets: selectedDatasets
    });
  }, [onChangeDatasetFilter]);
  const selectableOptions = (0, _react.useMemo)(() => availableDatasets.map(({
    dataset,
    warnings
  }) => ({
    label: dataset,
    append: warnings.length > 0 ? /*#__PURE__*/_react.default.createElement(DatasetWarningMarker, {
      warnings: warnings
    }) : null,
    checked: datasetFilter.type === 'includeSome' && datasetFilter.datasets.includes(dataset) ? 'on' : undefined
  })), [availableDatasets, datasetFilter]);
  const datasetFilterButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    disabled: isDisabled,
    isSelected: isVisible,
    onClick: show,
    iconType: "arrowDown"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.indexDatasetFilterIncludeAllButtonLabel",
    defaultMessage: "{includeType, select, includeAll {All datasets} includeSome {{includedDatasetCount, plural, one {# dataset} other {# datasets}}}}",
    values: {
      includeType: datasetFilter.type,
      includedDatasetCount: datasetFilter.type === 'includeSome' ? datasetFilter.datasets.length : 0
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: datasetFilterButton,
    closePopover: hide,
    isOpen: isVisible,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    onChange: changeDatasetFilter,
    options: selectableOptions,
    searchable: true
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, search), list))));
};
exports.IndexSetupDatasetFilter = IndexSetupDatasetFilter;
const DatasetWarningMarker = ({
  warnings
}) => {
  const warningDescriptions = warnings.flatMap(warning => warning.type === 'categoryQualityWarning' ? warning.reasons.map(reason => /*#__PURE__*/_react.default.createElement(_quality_warning_notices.CategoryQualityWarningReasonDescription, {
    key: reason.type,
    reason: reason
  })) : []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: warningDescriptions,
    type: "warning",
    color: "warning"
  });
};