"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KPIGrid = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _visualizations = require("../../../../../common/visualizations");
var _kpi = require("./kpi");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KPIGrid = ({
  assetName,
  dataView,
  dateRange
}) => {
  const model = (0, _common.findInventoryModel)('host');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    value: dashboards
  } = (0, _useAsync.default)(() => {
    return model.metrics.getDashboards();
  });
  const charts = (0, _react.useMemo)(() => {
    var _dashboards$kpi$get$c;
    return (_dashboards$kpi$get$c = dashboards === null || dashboards === void 0 ? void 0 : dashboards.kpi.get({
      metricsDataView: dataView,
      options: {
        backgroundColor: euiTheme.colors.lightestShade
      }
    }).charts) !== null && _dashboards$kpi$get$c !== void 0 ? _dashboards$kpi$get$c : [];
  }, [dataView, euiTheme.colors.lightestShade, dashboards === null || dashboards === void 0 ? void 0 : dashboards.kpi]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    "data-test-subj": "infraAssetDetailsKPIGrid"
  }, charts.map((chartProps, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_kpi.Kpi, (0, _extends2.default)({}, chartProps, {
    dateRange: dateRange,
    assetName: assetName,
    height: _visualizations.KPI_CHART_HEIGHT
  })))));
};
exports.KPIGrid = KPIGrid;