"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Table = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _add_metadata_filter_button = require("./add_metadata_filter_button");
var _expandable_content = require("../../components/expandable_content");
var _utils = require("./utils");
var _add_pin_to_row = require("./add_pin_to_row");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Columns translations
 */
const FIELD_LABEL = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.field', {
  defaultMessage: 'Field'
});
const VALUE_LABEL = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.value', {
  defaultMessage: 'Value'
});

/**
 * Component translations
 */
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.searchForMetadata', {
  defaultMessage: 'Search for metadata…'
});
const NO_METADATA_FOUND = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.noMetadataFound', {
  defaultMessage: 'No metadata found.'
});
const LOADING = _i18n.i18n.translate('xpack.infra.metadataEmbeddable.loading', {
  defaultMessage: 'Loading...'
});
const LOCAL_STORAGE_PINNED_METADATA_ROWS = 'hostsView:pinnedMetadataRows';
const Table = ({
  loading,
  rows,
  onSearchChange,
  search,
  showActionsColumn
}) => {
  const [searchError, setSearchError] = (0, _react.useState)(null);
  const [metadataSearch, setMetadataSearch] = (0, _react.useState)(search);
  const [fieldsWithPins, setFieldsWithPins] = (0, _react.useState)(rows);
  const [pinnedItems, setPinnedItems] = (0, _useLocalStorage.default)(LOCAL_STORAGE_PINNED_METADATA_ROWS, []);
  (0, _react.useMemo)(() => {
    if (pinnedItems) {
      var _getRowsWithPins;
      setFieldsWithPins((_getRowsWithPins = (0, _utils.getRowsWithPins)(rows, pinnedItems)) !== null && _getRowsWithPins !== void 0 ? _getRowsWithPins : rows);
    }
  }, [rows, pinnedItems]);
  const defaultColumns = (0, _react.useMemo)(() => [{
    field: 'value',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pin"
    }),
    align: 'center',
    width: '5%',
    sortable: false,
    showOnHover: true,
    render: (_name, item) => {
      return /*#__PURE__*/_react.default.createElement(_add_pin_to_row.AddMetadataPinToRow, {
        fieldName: item.name,
        pinnedItems: pinnedItems !== null && pinnedItems !== void 0 ? pinnedItems : [],
        onPinned: setPinnedItems
      });
    }
  }, {
    field: 'name',
    name: FIELD_LABEL,
    width: '35%',
    sortable: false,
    render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, name)
  }, {
    field: 'value',
    name: VALUE_LABEL,
    width: '50%',
    sortable: false,
    render: (_name, item) => /*#__PURE__*/_react.default.createElement(_expandable_content.ExpandableContent, {
      values: item.value
    })
  }], [pinnedItems, setPinnedItems]);
  const debouncedSearchOnChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(queryText => {
    if (onSearchChange) {
      onSearchChange(queryText);
    }
    setMetadataSearch(queryText);
  }, 500), [onSearchChange]);
  const searchBarOnChange = (0, _react.useCallback)(({
    queryText,
    error
  }) => {
    if (error) {
      setSearchError(error);
    } else {
      setSearchError(null);
      debouncedSearchOnChange(queryText);
    }
  }, [debouncedSearchOnChange]);
  const searchBar = {
    onChange: searchBarOnChange,
    box: {
      'data-test-subj': 'infraAssetDetailsMetadataSearchBarInput',
      incremental: true,
      schema: true,
      placeholder: SEARCH_PLACEHOLDER
    },
    query: metadataSearch ? _eui.Query.parse(metadataSearch) : _eui.Query.MATCH_ALL
  };
  const columns = (0, _react.useMemo)(() => showActionsColumn ? [...defaultColumns, {
    field: 'value',
    name: 'Actions',
    sortable: false,
    showOnHover: true,
    align: 'center',
    render: (_name, item) => {
      return /*#__PURE__*/_react.default.createElement(_add_metadata_filter_button.AddMetadataFilterButton, {
        item: item
      });
    }
  }] : defaultColumns, [defaultColumns, showActionsColumn]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "infraAssetDetailsMetadataTable",
    tableLayout: "fixed",
    responsive: false,
    columns: columns,
    items: fieldsWithPins,
    rowProps: {
      className: 'euiTableRow-hasActions'
    },
    search: searchBar,
    loading: loading,
    error: searchError ? `${searchError.message}` : '',
    message: loading ? /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "infraAssetDetailsMetadataLoading"
    }, LOADING) : /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "infraAssetDetailsMetadataNoData"
    }, NO_METADATA_FOUND)
  });
};
exports.Table = Table;