"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Popover = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _use_boolean = require("../../../../hooks/use_boolean");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Popover = ({
  children,
  icon,
  iconColor,
  iconSize,
  ...props
}) => {
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _use_boolean.useBoolean)(false);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "s",
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      "data-test-subj": props['data-test-subj'],
      type: icon,
      color: iconColor !== null && iconColor !== void 0 ? iconColor : 'text',
      size: iconSize !== null && iconSize !== void 0 ? iconSize : 'original',
      onClick: togglePopover,
      css: (0, _react.css)`
            cursor: pointer;
          `
    }),
    isOpen: isPopoverOpen,
    offset: 10,
    closePopover: closePopover,
    repositionOnScroll: true,
    anchorPosition: "upCenter",
    panelStyle: {
      maxWidth: 350
    }
  }, children);
};
exports.Popover = Popover;