"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Anomalies = void 0;
var _react = _interopRequireWildcard(require("react"));
var _anomalies_table = require("../../../../pages/metrics/inventory_view/components/ml/anomaly_detection/anomalies_table/anomalies_table");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_date_picker = require("../../hooks/use_date_picker");
var _use_intersecting_state = require("../../hooks/use_intersecting_state");
var _use_request_observable = require("../../hooks/use_request_observable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Anomalies = () => {
  var _overrides$anomalies;
  const ref = (0, _react.useRef)(null);
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const {
    getParsedDateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    asset,
    overrides
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    onClose = () => {}
  } = (_overrides$anomalies = overrides === null || overrides === void 0 ? void 0 : overrides.anomalies) !== null && _overrides$anomalies !== void 0 ? _overrides$anomalies : {};
  const parsedDateRange = (0, _react.useMemo)(() => getParsedDateRange(), [getParsedDateRange]);
  const state = (0, _use_intersecting_state.useIntersectingState)(ref, {
    parsedDateRange
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_anomalies_table.AnomaliesTable, {
    closeFlyout: onClose,
    hostName: asset.name,
    dateRange: state.parsedDateRange,
    hideDatePicker: true,
    request$: request$
  }));
};
exports.Anomalies = Anomalies;