"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadingStateContext = exports.useLoadingState = exports.LoadingStateProvider = void 0;
var _operators = require("rxjs/operators");
var _constate = _interopRequireDefault(require("constate"));
var _rxjs = require("rxjs");
var _react = require("react");
var _public = require("@kbn/data-plugin/public");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_date_picker = require("./use_date_picker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WAIT_MS = 1000;
const useLoadingState = () => {
  const {
    autoRefreshTick$,
    autoRefreshConfig$
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    data: {
      search
    }
  } = services;
  const isAutoRefreshRequestPending$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(false), []);
  const requestsCount$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(0), []);
  const requestState$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(null), []);
  const [searchSessionId, setSearchSessionId] = (0, _react.useState)();
  const updateSearchSessionId = (0, _react.useCallback)(() => {
    setSearchSessionId(() => search.session.start());
  }, [search.session]);
  const waitUntilRequestsCompletes$ = (0, _react.useCallback)(() => requestsCount$.pipe((0, _operators.distinctUntilChanged)(),
  // Skip values emitted by subject$ until the first state equals 0.
  (0, _operators.skipUntil)(requestsCount$.pipe((0, _operators.first)(state => state === 0))),
  // Wait for a specified period of idle time before emitting a value.
  (0, _operators.debounceTime)(WAIT_MS),
  // Emit the first value where state equals 0.
  (0, _operators.first)(state => state === 0)), [requestsCount$]);
  const isAutoRefreshEnabled$ = (0, _react.useCallback)(() => autoRefreshConfig$.pipe((0, _operators.first)(config => {
    return !!config && config.isPaused !== true;
  })), [autoRefreshConfig$]);
  (0, _react.useEffect)(() => {
    updateSearchSessionId();
  }, [updateSearchSessionId]);
  (0, _react.useEffect)(() => {
    // Subscribe to updates in the request state
    const requestStateSubscription = requestState$.pipe((0, _operators.filter)(status => !!status), (0, _operators.map)(status => ['error', 'done'].includes(status) ? -1 : 1), (0, _operators.tap)(value => {
      // Update the number of running requests
      // NOTE: We could use the http.getLoadingCount$ instead, to count the number of HTTP requests.
      // However, it would consider the whole page, and here we're limiting the scope to the http requests that happen in the Asset Details context.
      requestsCount$.next(requestsCount$.getValue() + value);
    }),
    // Concatenate with loadingCounter$ observable
    (0, _operators.switchMap)(() => requestsCount$.pipe((0, _operators.distinctUntilChanged)(), (0, _operators.skipUntil)(isAutoRefreshEnabled$()), (0, _operators.debounceTime)(WAIT_MS),
    // Small window for requests to be considered in the auto-refresh cycle
    (0, _operators.tap)(runningRequestsCount => {
      if (runningRequestsCount > 0) {
        // isAutoRefreshRequestPending$.next is only set to false in the autoRefreshTick$ subscription
        // which will allow us to control when new requests can be made.
        isAutoRefreshRequestPending$.next(true);
      }
    })))).subscribe();

    // Subscribe to autoRefreshTick$ observable
    const autoRefreshTickSubscription = (0, _rxjs.merge)(autoRefreshTick$.pipe((0, _operators.skipUntil)(isAutoRefreshEnabled$()), (0, _operators.withLatestFrom)(requestsCount$), (0, _operators.switchMap)(([, count]) =>
    // Any request called using `use_request_observable` will fall into this case
    // If there are still pending requests
    (0, _rxjs.iif)(() => count > 0,
    // Wait until requests complete before processing the next tick
    waitUntilRequestsCompletes$().pipe((0, _operators.tap)(() => isAutoRefreshRequestPending$.next(false))),
    // Else immediately emit false if the counter is already 0
    new _rxjs.Observable(() => {
      isAutoRefreshRequestPending$.next(false);
    })))), autoRefreshTick$.pipe((0, _operators.skipUntil)(isAutoRefreshEnabled$()), (0, _operators.withLatestFrom)(search.session.state$), (0, _operators.switchMap)(([, state]) =>
    // if the current state$ value is not Completed
    (0, _rxjs.iif)(() => state !== _public.SearchSessionState.Completed && state !== _public.SearchSessionState.BackgroundCompleted,
    // Wait until queries using data.search complete before processing the next tick
    // data.search in the context of the Asset Details is used by Lens.
    (0, _public.waitUntilNextSessionCompletes$)(search.session).pipe((0, _operators.tap)(() => updateSearchSessionId())),
    // Else mmediately emit true if session state is already completed
    new _rxjs.Observable(() => {
      updateSearchSessionId();
    }))))).subscribe();
    return () => {
      requestStateSubscription.unsubscribe();
      autoRefreshTickSubscription.unsubscribe();
    };
  }, [autoRefreshTick$, isAutoRefreshEnabled$, isAutoRefreshRequestPending$, requestState$, requestsCount$, search.session, updateSearchSessionId, waitUntilRequestsCompletes$]);
  return {
    updateSearchSessionId,
    searchSessionId,
    requestState$,
    isAutoRefreshRequestPending$
  };
};
exports.useLoadingState = useLoadingState;
const [LoadingStateProvider, useLoadingStateContext] = (0, _constate.default)(useLoadingState);
exports.useLoadingStateContext = useLoadingStateContext;
exports.LoadingStateProvider = LoadingStateProvider;