"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopProcessesTooltip = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _popover = require("../tabs/common/popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DOCUMENTATION_LINK = 'https://www.elastic.co/guide/en/observability/current/view-infrastructure-metrics.html';
const SYSTEM_INTEGRATION_DOCS_LINK = 'https://docs.elastic.co/en/integrations/system';
const TopProcessesTooltip = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    "aria-label": _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processesHeader.tooltipLabel', {
      defaultMessage: 'More info'
    }),
    iconSize: "m",
    icon: "iInCircle",
    "data-test-subj": "infraAssetDetailsProcessesPopoverButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.tooltip.topProcesses",
    defaultMessage: "The processes listed are based on an aggregation of the top CPU and the top memory consuming processes. It does not show all processes."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.tooltip.label",
    defaultMessage: "The number of top processes is configurable in the {systemIntegration}.",
    values: {
      systemIntegration: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraAssetDetailsTooltipSystemIntegrationDocumentationLink",
        href: SYSTEM_INTEGRATION_DOCS_LINK,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.processes.tooltip.systemIntegrationDocumentationLink",
        defaultMessage: "System Integration"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.tooltip.documentationLabel",
    defaultMessage: "Please see the following {documentation} for more details on processes.",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraAssetDetailsTooltipDocumentationLink",
        href: DOCUMENTATION_LINK,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.processes.tooltip.documentationLink",
        defaultMessage: "documentation"
      }))
    }
  }))));
});
exports.TopProcessesTooltip = TopProcessesTooltip;