"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailsEmbeddableFactoryDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _asset_details_embeddable = require("./asset_details_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AssetDetailsEmbeddableFactoryDefinition {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _asset_details_embeddable.ASSET_DETAILS_EMBEDDABLE);
    this.getStartServices = getStartServices;
  }
  async isEditable() {
    return false;
  }
  async create(initialInput, parent) {
    const [core, plugins, pluginStart] = await this.getStartServices();
    return new _asset_details_embeddable.AssetDetailsEmbeddable(core, plugins, pluginStart, initialInput, parent);
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.infra.assetDetailsEmbeddable.displayName', {
      defaultMessage: 'Asset Details'
    });
  }
  getDescription() {
    return _i18n.i18n.translate('xpack.infra.assetDetailsEmbeddable.description', {
      defaultMessage: 'Add an asset details view.'
    });
  }
  getIconType() {
    return 'metricsApp';
  }
  async getExplicitInput() {
    return {
      title: _i18n.i18n.translate('xpack.infra.assetDetailsEmbeddable.title', {
        defaultMessage: 'Asset Details'
      })
    };
  }
}
exports.AssetDetailsEmbeddableFactoryDefinition = AssetDetailsEmbeddableFactoryDefinition;