"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecorateWithKibanaContext = exports.DecorateWithAssetDetailsStateContext = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _rxjs = require("rxjs");
var _addonActions = require("@storybook/addon-actions");
var _addons = require("@storybook/addons");
var _alert_summary_widget = require("@kbn/triggers-actions-ui-plugin/public/application/sections/alert_summary_widget/alert_summary_widget");
var _common = require("@kbn/logs-shared-plugin/common");
var _reactRouterDom = require("react-router-dom");
var _plugin_config_context = require("../../../containers/plugin_config_context");
var _metrics_source = require("../../../containers/metrics_source");
var _http = require("./context/http");
var _fixtures = require("./context/fixtures");
var _context_providers = require("../context_providers");
var _use_data_views = require("../hooks/use_data_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const settings = {
  'dateFormat:scaled': [['', 'HH:mm:ss.SSS']]
};
const getSettings = key => settings[key];
const mockDataView = {
  id: 'default',
  getFieldByName: () => 'hostname'
};
const DecorateWithKibanaContext = story => {
  const initialProcesses = (0, _addons.useParameter)('apiResponse', {
    mock: 'default'
  });
  const mockServices = {
    application: {
      currentAppId$: (0, _rxjs.of)('infra'),
      navigateToUrl: async url => {
        (0, _addonActions.action)(`Navigate to: ${url}`);
      },
      getUrlForApp: url => url
    },
    data: {
      search: {
        search: (request, options) => {
          return (0, _fixtures.getLogEntries)(request, options);
        },
        session: {
          start: () => 'started',
          state$: {
            closed: false
          }
        }
      },
      query: {
        filterManager: {
          addFilters: () => {},
          removeFilter: () => {}
        }
      }
    },
    dataViews: {
      create: () => Promise.resolve(mockDataView)
    },
    locators: {
      nodeLogsLocator: {
        getRedirectUrl: () => {
          return '';
        }
      }
    },
    uiActions: {
      getTriggerCompatibleActions: () => {
        return Promise.resolve([]);
      }
    },
    uiSettings: {
      get: () => ({
        key: 'mock',
        defaultOverride: undefined
      })
    },
    triggersActionsUi: {
      getAlertSummaryWidget: _alert_summary_widget.AlertSummaryWidget
    },
    charts: {
      theme: {
        useChartsTheme: () => ({}),
        useChartsBaseTheme: () => ({})
      }
    },
    settings: {
      client: {
        get$: key => (0, _rxjs.of)(getSettings(key)),
        get: getSettings
      }
    },
    notifications: {
      toasts: {
        add: params => {
          (0, _addonActions.action)('notifications.toats.add')(params);
          return {
            id: 'id'
          };
        }
      }
    },
    http: (0, _http.getHttp)(initialProcesses),
    share: {
      url: {
        locators: {
          get: _id => ({
            navigate: async () => {
              return Promise.resolve();
            }
          })
        }
      }
    },
    logsShared: {
      logViews: {
        client: {
          getLogView: () => Promise.resolve({
            id: 'log',
            attributes: _common.defaultLogViewAttributes,
            origin: 'internal'
          }),
          getResolvedLogView: () => Promise.resolve({
            dataViewReference: mockDataView
          })
        }
      }
    },
    lens: {
      navigateToPrefilledEditor: () => {},
      stateHelperApi: () => new Promise(() => {})
    },
    telemetry: {
      reportAssetDetailsFlyoutViewed: () => {},
      reportAssetDetailsPageViewed: () => {}
    }
  };
  const config = {
    alerting: {
      inventory_threshold: {
        group_by_page_size: 11
      },
      metric_threshold: {
        group_by_page_size: 11
      }
    },
    enabled: true,
    inventory: {
      compositeSize: 11
    },
    sources: {
      default: {
        fields: {
          message: ['default']
        }
      }
    },
    featureFlags: {
      customThresholdAlertsEnabled: true,
      logsUIEnabled: false,
      metricsExplorerEnabled: false,
      osqueryEnabled: true,
      inventoryThresholdAlertRuleEnabled: true,
      metricThresholdAlertRuleEnabled: true,
      logThresholdAlertRuleEnabled: true,
      alertsAndRulesDropdownEnabled: true,
      profilingEnabled: false
    }
  };
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.MemoryRouter, {
    initialEntries: ['/infra/metrics/hosts']
  }, /*#__PURE__*/_react.default.createElement(_plugin_config_context.PluginConfigProvider, {
    value: config
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: mockServices
  }, /*#__PURE__*/_react.default.createElement(_metrics_source.SourceProvider, {
    sourceId: "default"
  }, story())))));
};
exports.DecorateWithKibanaContext = DecorateWithKibanaContext;
const DecorateWithAssetDetailsStateContext = story => {
  return /*#__PURE__*/_react.default.createElement(_context_providers.ContextProviders, (0, _extends2.default)({}, _fixtures.assetDetailsProps, {
    dateRange: {
      from: '2023-04-09T11:07:49Z',
      to: '2023-04-09T11:23:49Z'
    }
  }), /*#__PURE__*/_react.default.createElement(_use_data_views.DataViewsProvider, {
    metricAlias: "metrics-*"
  }, story()));
};
exports.DecorateWithAssetDetailsStateContext = DecorateWithAssetDetailsStateContext;