"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.commonFlyoutTabs = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _types = require("../../components/asset_details/types");
var _new_badge = require("../../components/new_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonFlyoutTabs = [{
  id: _types.ContentTabIds.OVERVIEW,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.overview.title', {
    defaultMessage: 'Overview'
  })
}, {
  id: _types.ContentTabIds.METADATA,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metadata.title', {
    defaultMessage: 'Metadata'
  })
}, {
  id: _types.ContentTabIds.PROCESSES,
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.tabs.processes', {
    defaultMessage: 'Processes'
  })
}, {
  id: _types.ContentTabIds.PROFILING,
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.tabs.profiling', {
    defaultMessage: 'Universal Profiling'
  }),
  append: /*#__PURE__*/_react.default.createElement(_new_badge.NewBadge, null)
}, {
  id: _types.ContentTabIds.LOGS,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.logs.title', {
    defaultMessage: 'Logs'
  })
}, {
  id: _types.ContentTabIds.ANOMALIES,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.anomalies', {
    defaultMessage: 'Anomalies'
  })
}, {
  id: _types.ContentTabIds.OSQUERY,
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.osquery', {
    defaultMessage: 'Osquery'
  })
}];
exports.commonFlyoutTabs = commonFlyoutTabs;