"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAlertsEsQuery = void 0;
var _common = require("@kbn/data-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _esQuery = require("@kbn/es-query");
var _constants = require("./constants");
var _build = require("../../utils/filters/build");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAlertsEsQuery = ({
  dateRange,
  hostNodeNames,
  status
}) => {
  const alertStatusFilter = createAlertStatusFilter(status);
  const dateFilter = createDateFilter(dateRange);
  const hostsFilter = (0, _build.buildCombinedHostsFilter)({
    field: 'host.name',
    values: hostNodeNames
  });
  const filters = [alertStatusFilter, dateFilter, hostsFilter].filter(Boolean);
  return (0, _esQuery.buildEsQuery)(undefined, [], filters);
};
exports.createAlertsEsQuery = createAlertsEsQuery;
const createDateFilter = date => (0, _common.getTime)(undefined, date, {
  fieldName: _ruleDataUtils.ALERT_TIME_RANGE
});
const createAlertStatusFilter = (status = 'all') => _constants.ALERT_STATUS_QUERY[status] ? {
  query: _constants.ALERT_STATUS_QUERY[status],
  meta: {}
} : null;