"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.singleMetricsExplorerViewRT = exports.metricsExplorerViewRT = exports.metricsExplorerViewBasicAttributesRT = exports.metricsExplorerViewAttributesRT = exports.metricsExplorerTimeOptionsRT = exports.metricsExplorerOptionsRT = exports.metricsExplorerChartOptionsRT = exports.metricExplorerViewStateRT = exports.metricExplorerOptionsRequiredRT = exports.metricExplorerOptionsOptionalRT = exports.inventorySortOptionRT = exports.MetricsExplorerYAxisMode = exports.MetricsExplorerChartType = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
var _color_palette = require("../color_palette");
var _metrics_explorer = require("../http_api/metrics_explorer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const inventorySortOptionRT = rt.type({
  by: rt.keyof({
    name: null,
    value: null
  }),
  direction: rt.keyof({
    asc: null,
    desc: null
  })
});
exports.inventorySortOptionRT = inventorySortOptionRT;
let MetricsExplorerChartType;
exports.MetricsExplorerChartType = MetricsExplorerChartType;
(function (MetricsExplorerChartType) {
  MetricsExplorerChartType["line"] = "line";
  MetricsExplorerChartType["area"] = "area";
  MetricsExplorerChartType["bar"] = "bar";
})(MetricsExplorerChartType || (exports.MetricsExplorerChartType = MetricsExplorerChartType = {}));
let MetricsExplorerYAxisMode;
exports.MetricsExplorerYAxisMode = MetricsExplorerYAxisMode;
(function (MetricsExplorerYAxisMode) {
  MetricsExplorerYAxisMode["fromZero"] = "fromZero";
  MetricsExplorerYAxisMode["auto"] = "auto";
})(MetricsExplorerYAxisMode || (exports.MetricsExplorerYAxisMode = MetricsExplorerYAxisMode = {}));
const metricsExplorerChartOptionsRT = rt.type({
  yAxisMode: rt.keyof(Object.fromEntries(Object.values(MetricsExplorerYAxisMode).map(v => [v, null]))),
  type: rt.keyof(Object.fromEntries(Object.values(MetricsExplorerChartType).map(v => [v, null]))),
  stack: rt.boolean
});
exports.metricsExplorerChartOptionsRT = metricsExplorerChartOptionsRT;
const metricsExplorerTimeOptionsRT = rt.type({
  from: rt.string,
  to: rt.string,
  interval: rt.string
});
exports.metricsExplorerTimeOptionsRT = metricsExplorerTimeOptionsRT;
const metricsExplorerOptionsMetricRT = rt.intersection([_metrics_explorer.metricsExplorerMetricRT, rt.partial({
  rate: rt.boolean,
  color: rt.keyof(Object.fromEntries(Object.values(_color_palette.Color).map(c => [c, null]))),
  label: rt.string
})]);
const metricExplorerOptionsRequiredRT = rt.type({
  aggregation: _metrics_explorer.metricsExplorerAggregationRT,
  metrics: rt.array(metricsExplorerOptionsMetricRT)
});
exports.metricExplorerOptionsRequiredRT = metricExplorerOptionsRequiredRT;
const metricExplorerOptionsOptionalRT = rt.partial({
  limit: rt.number,
  groupBy: rt.union([rt.string, rt.array(rt.string)]),
  filterQuery: rt.string,
  source: rt.string,
  forceInterval: rt.boolean,
  dropLastBucket: rt.boolean
});
exports.metricExplorerOptionsOptionalRT = metricExplorerOptionsOptionalRT;
const metricsExplorerOptionsRT = rt.intersection([metricExplorerOptionsRequiredRT, metricExplorerOptionsOptionalRT]);
exports.metricsExplorerOptionsRT = metricsExplorerOptionsRT;
const metricExplorerViewStateRT = rt.type({
  chartOptions: metricsExplorerChartOptionsRT,
  currentTimerange: metricsExplorerTimeOptionsRT,
  options: metricsExplorerOptionsRT
});
exports.metricExplorerViewStateRT = metricExplorerViewStateRT;
const metricsExplorerViewBasicAttributesRT = rt.type({
  name: _ioTsUtils.nonEmptyStringRt
});
exports.metricsExplorerViewBasicAttributesRT = metricsExplorerViewBasicAttributesRT;
const metricsExplorerViewFlagsRT = rt.partial({
  isDefault: rt.boolean,
  isStatic: rt.boolean
});
const metricsExplorerViewAttributesRT = rt.intersection([metricExplorerViewStateRT, metricsExplorerViewBasicAttributesRT, metricsExplorerViewFlagsRT]);
exports.metricsExplorerViewAttributesRT = metricsExplorerViewAttributesRT;
const singleMetricsExplorerViewAttributesRT = rt.exact(rt.intersection([metricsExplorerViewBasicAttributesRT, metricsExplorerViewFlagsRT]));
const metricsExplorerViewRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  attributes: metricsExplorerViewAttributesRT
}), rt.partial({
  updatedAt: _ioTsUtils.isoToEpochRt,
  version: rt.string
})]));
exports.metricsExplorerViewRT = metricsExplorerViewRT;
const singleMetricsExplorerViewRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  attributes: singleMetricsExplorerViewAttributesRT
}), rt.partial({
  updatedAt: _ioTsUtils.isoToEpochRt,
  version: rt.string
})]));
exports.singleMetricsExplorerViewRT = singleMetricsExplorerViewRT;