"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsExplorerViewResponsePayloadRT = exports.metricsExplorerViewRequestQueryRT = exports.metricsExplorerViewRequestParamsRT = exports.getMetricsExplorerViewUrl = exports.METRICS_EXPLORER_VIEW_URL_ENTITY = exports.METRICS_EXPLORER_VIEW_URL = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _Either = require("fp-ts/Either");
var _metrics_explorer_views = require("../../../metrics_explorer_views");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRICS_EXPLORER_VIEW_URL = '/api/infra/metrics_explorer_views';
exports.METRICS_EXPLORER_VIEW_URL = METRICS_EXPLORER_VIEW_URL;
const METRICS_EXPLORER_VIEW_URL_ENTITY = `${METRICS_EXPLORER_VIEW_URL}/{metricsExplorerViewId}`;
exports.METRICS_EXPLORER_VIEW_URL_ENTITY = METRICS_EXPLORER_VIEW_URL_ENTITY;
const getMetricsExplorerViewUrl = metricsExplorerViewId => [METRICS_EXPLORER_VIEW_URL, metricsExplorerViewId].filter(Boolean).join('/');
exports.getMetricsExplorerViewUrl = getMetricsExplorerViewUrl;
const metricsExplorerViewIdRT = new rt.Type('MetricsExplorerViewId', rt.string.is, (u, c) => _Either.either.chain(rt.string.validate(u, c), id => {
  return id === '0' ? rt.failure(u, c, `The metrics explorer view with id ${id} is not configurable.`) : rt.success(id);
}), String);
const metricsExplorerViewRequestParamsRT = rt.type({
  metricsExplorerViewId: metricsExplorerViewIdRT
});
exports.metricsExplorerViewRequestParamsRT = metricsExplorerViewRequestParamsRT;
const metricsExplorerViewRequestQueryRT = rt.partial({
  sourceId: rt.string
});
exports.metricsExplorerViewRequestQueryRT = metricsExplorerViewRequestQueryRT;
const metricsExplorerViewResponsePayloadRT = rt.type({
  data: _metrics_explorer_views.metricsExplorerViewRT
});
exports.metricsExplorerViewResponsePayloadRT = metricsExplorerViewResponsePayloadRT;