"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rowStatus = void 0;
var _reduxActions = require("redux-actions");
var _actions = require("../actions");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rowStatus = (0, _reduxActions.handleActions)({
  [_actions.clearRowStatus](state, action) {
    const {
      indexNames
    } = action.payload;
    const newState = {
      ...state
    };
    indexNames.forEach(indexName => {
      delete newState[indexName];
    });
    return newState;
  },
  [_actions.closeIndicesStart](state, action) {
    const {
      indexNames
    } = action.payload;
    const statuses = {};
    indexNames.forEach(indexName => {
      statuses[indexName] = _constants.INDEX_CLOSING;
    });
    return {
      ...state,
      ...statuses
    };
  },
  [_actions.openIndicesStart](state, action) {
    const {
      indexNames
    } = action.payload;
    const statuses = {};
    indexNames.forEach(indexName => {
      statuses[indexName] = _constants.INDEX_OPENING;
    });
    return {
      ...state,
      ...statuses
    };
  },
  [_actions.refreshIndicesStart](state, action) {
    const {
      indexNames
    } = action.payload;
    const statuses = {};
    indexNames.forEach(indexName => {
      statuses[indexName] = _constants.INDEX_REFRESHING;
    });
    return {
      ...state,
      ...statuses
    };
  },
  [_actions.flushIndicesStart](state, action) {
    const {
      indexNames
    } = action.payload;
    const statuses = {};
    indexNames.forEach(indexName => {
      statuses[indexName] = _constants.INDEX_FLUSHING;
    });
    return {
      ...state,
      ...statuses
    };
  },
  [_actions.forcemergeIndicesStart](state, action) {
    const {
      indexNames
    } = action.payload;
    const statuses = {};
    indexNames.forEach(indexName => {
      statuses[indexName] = _constants.INDEX_FORCEMERGING;
    });
    return {
      ...state,
      ...statuses
    };
  },
  [_actions.clearCacheIndicesStart](state, action) {
    const {
      indexNames
    } = action.payload;
    const statuses = {};
    indexNames.forEach(indexName => {
      statuses[indexName] = _constants.INDEX_CLEARING_CACHE;
    });
    return {
      ...state,
      ...statuses
    };
  },
  [_actions.reloadIndicesSuccess](state, action) {
    const {
      indices
    } = action.payload;
    const indicesByName = indices.reduce((acc, index) => {
      acc[index.name] = index;
      return acc;
    }, {});
    const newState = {
      ...state
    };
    // eslint-disable-next-line guard-for-in
    for (const indexName in state) {
      if (state[indexName] === _constants.INDEX_CLOSING && indicesByName[indexName].status === _constants.INDEX_CLOSED) {
        delete newState[indexName];
      }
      if (state[indexName] === _constants.INDEX_OPENING && indicesByName[indexName].status === _constants.INDEX_OPEN) {
        delete newState[indexName];
      }
      if (state[indexName] === _constants.INDEX_REFRESHING && indicesByName[indexName].status === _constants.INDEX_OPEN) {
        delete newState[indexName];
      }
      if (state[indexName] === _constants.INDEX_REFRESHING && indicesByName[indexName].status === _constants.INDEX_CLOSED) {
        delete newState[indexName];
      }
      if (state[indexName] === _constants.INDEX_FLUSHING && indicesByName[indexName].status === _constants.INDEX_OPEN) {
        delete newState[indexName];
      }
      if (state[indexName] === _constants.INDEX_FLUSHING && indicesByName[indexName].status === _constants.INDEX_CLOSED) {
        delete newState[indexName];
      }
      if (state[indexName] === _constants.INDEX_FORCEMERGING && indicesByName[indexName].status === _constants.INDEX_OPEN) {
        delete newState[indexName];
      }
      if (state[indexName] === _constants.INDEX_FORCEMERGING && indicesByName[indexName].status === _constants.INDEX_CLOSED) {
        delete newState[indexName];
      }
      if (state[indexName] === _constants.INDEX_CLEARING_CACHE && indicesByName[indexName].status === _constants.INDEX_OPEN) {
        delete newState[indexName];
      }
      if (state[indexName] === _constants.INDEX_CLEARING_CACHE && indicesByName[indexName].status === _constants.INDEX_CLOSED) {
        delete newState[indexName];
      }
    }
    return newState;
  }
}, {});
exports.rowStatus = rowStatus;