"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indices = void 0;
var _redux = require("redux");
var _reduxActions = require("redux-actions");
var _actions = require("../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const byId = (0, _reduxActions.handleActions)({
  [_actions.deleteIndicesSuccess](state, action) {
    const {
      indexNames
    } = action.payload;
    const newState = {};
    Object.values(state).forEach(index => {
      if (!indexNames.includes(index.name)) {
        newState[index.name] = index;
      }
    });
    return newState;
  },
  [_actions.loadIndicesSuccess](state, action) {
    const {
      indices
    } = action.payload;
    const newState = {};
    indices.forEach(index => {
      newState[index.name] = index;
    });
    return newState;
  },
  [_actions.reloadIndicesSuccess](state, action) {
    const {
      indices
    } = action.payload;
    const newState = {};
    indices.forEach(index => {
      newState[index.name] = index;
    });
    return {
      ...state,
      ...newState
    };
  }
}, {});
const allIds = (0, _reduxActions.handleActions)({
  [_actions.deleteIndicesSuccess](state, action) {
    const {
      indexNames
    } = action.payload;
    const newState = [];
    state.forEach(indexName => {
      if (!indexNames.includes(indexName)) {
        newState.push(indexName);
      }
    });
    return newState;
  },
  [_actions.loadIndicesSuccess](state, action) {
    const {
      indices
    } = action.payload;
    return indices.map(index => index.name);
  },
  [_actions.reloadIndicesSuccess](state) {
    // the set of IDs should never change when refreshing indexes.
    return state;
  }
}, []);
const loading = (0, _reduxActions.handleActions)({
  [_actions.loadIndicesStart]() {
    return true;
  },
  [_actions.loadIndicesSuccess]() {
    return false;
  },
  [_actions.loadIndicesError]() {
    return false;
  }
}, true);
const error = (0, _reduxActions.handleActions)({
  [_actions.loadIndicesError](state, action) {
    const error = action.payload;
    const newState = {
      ...error
    };
    return newState;
  }
}, false);
const indices = (0, _redux.combineReducers)({
  loading,
  error,
  byId,
  allIds
});
exports.indices = indices;