"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearCacheIndices = clearCacheIndices;
exports.closeIndices = closeIndices;
exports.createEnrichPolicy = createEnrichPolicy;
exports.createIndex = createIndex;
exports.deleteDataStreams = deleteDataStreams;
exports.deleteEnrichPolicy = deleteEnrichPolicy;
exports.deleteIndices = deleteIndices;
exports.deleteTemplates = deleteTemplates;
exports.executeEnrichPolicy = executeEnrichPolicy;
exports.flushIndices = flushIndices;
exports.forcemergeIndices = forcemergeIndices;
exports.getFieldsFromIndices = getFieldsFromIndices;
exports.getMatchingIndices = getMatchingIndices;
exports.loadIndex = loadIndex;
exports.loadIndexMapping = loadIndexMapping;
exports.loadIndexSettings = loadIndexSettings;
exports.loadIndexStatistics = loadIndexStatistics;
exports.loadIndexStats = loadIndexStats;
exports.loadIndices = loadIndices;
exports.openIndices = openIndices;
exports.refreshIndices = refreshIndices;
exports.reloadIndices = reloadIndices;
exports.saveTemplate = saveTemplate;
exports.setUiMetricService = void 0;
exports.simulateIndexTemplate = simulateIndexTemplate;
exports.unfreezeIndices = unfreezeIndices;
exports.updateDataRetention = updateDataRetention;
exports.updateIndexSettings = updateIndexSettings;
exports.updateTemplate = updateTemplate;
exports.useLoadDataStream = useLoadDataStream;
exports.useLoadDataStreams = useLoadDataStreams;
exports.useLoadEnrichPolicies = void 0;
exports.useLoadIndexMappings = useLoadIndexMappings;
exports.useLoadIndexSettings = useLoadIndexSettings;
exports.useLoadIndexTemplate = useLoadIndexTemplate;
exports.useLoadIndexTemplates = useLoadIndexTemplates;
exports.useLoadNodesPlugins = useLoadNodesPlugins;
var _analytics = require("@kbn/analytics");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
var _http = require("./http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Temporary hack to provide the uiMetricService instance to this file.
// TODO: Refactor and export an ApiService instance through the app dependencies context
let uiMetricService;
const setUiMetricService = _uiMetricService => {
  uiMetricService = _uiMetricService;
};
// End hack
exports.setUiMetricService = setUiMetricService;
function useLoadDataStreams({
  includeStats
}) {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}/data_streams`,
    method: 'get',
    query: {
      includeStats
    }
  });
}
function useLoadDataStream(name) {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}/data_streams/${encodeURIComponent(name)}`,
    method: 'get'
  });
}
async function deleteDataStreams(dataStreams) {
  return (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}/delete_data_streams`,
    method: 'post',
    body: {
      dataStreams
    }
  });
}
async function updateDataRetention(name, data) {
  let body;
  if (!data.dataRetentionEnabled) {
    body = {
      enabled: false
    };
  } else {
    body = data.infiniteRetentionPeriod ? {} : {
      dataRetention: `${data.dataRetention}${data.timeUnit}`
    };
  }
  return (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}/data_streams/${encodeURIComponent(name)}/data_retention`,
    method: 'put',
    body
  });
}
async function loadIndices() {
  const response = await _http.httpService.httpClient.get(`${_constants.API_BASE_PATH}/indices`);
  return response.data ? response.data : response;
}
async function reloadIndices(indexNames, {
  asSystemRequest
} = {}) {
  const body = JSON.stringify({
    indexNames
  });
  const response = await _http.httpService.httpClient.post(`${_constants.API_BASE_PATH}/indices/reload`, {
    body,
    asSystemRequest
  });
  return response.data ? response.data : response;
}
async function closeIndices(indices) {
  const body = JSON.stringify({
    indices
  });
  const response = await _http.httpService.httpClient.post(`${_constants.API_BASE_PATH}/indices/close`, {
    body
  });
  // Only track successful requests.
  const eventName = indices.length > 1 ? _constants.UIM_INDEX_CLOSE_MANY : _constants.UIM_INDEX_CLOSE;
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, eventName);
  return response;
}
async function deleteIndices(indices) {
  const body = JSON.stringify({
    indices
  });
  const response = await _http.httpService.httpClient.post(`${_constants.API_BASE_PATH}/indices/delete`, {
    body
  });
  // Only track successful requests.
  const eventName = indices.length > 1 ? _constants.UIM_INDEX_DELETE_MANY : _constants.UIM_INDEX_DELETE;
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, eventName);
  return response;
}
async function openIndices(indices) {
  const body = JSON.stringify({
    indices
  });
  const response = await _http.httpService.httpClient.post(`${_constants.API_BASE_PATH}/indices/open`, {
    body
  });
  // Only track successful requests.
  const eventName = indices.length > 1 ? _constants.UIM_INDEX_OPEN_MANY : _constants.UIM_INDEX_OPEN;
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, eventName);
  return response;
}
async function refreshIndices(indices) {
  const body = JSON.stringify({
    indices
  });
  const response = await _http.httpService.httpClient.post(`${_constants.API_BASE_PATH}/indices/refresh`, {
    body
  });
  // Only track successful requests.
  const eventName = indices.length > 1 ? _constants.UIM_INDEX_REFRESH_MANY : _constants.UIM_INDEX_REFRESH;
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, eventName);
  return response;
}
async function flushIndices(indices) {
  const body = JSON.stringify({
    indices
  });
  const response = await _http.httpService.httpClient.post(`${_constants.API_BASE_PATH}/indices/flush`, {
    body
  });
  // Only track successful requests.
  const eventName = indices.length > 1 ? _constants.UIM_INDEX_FLUSH_MANY : _constants.UIM_INDEX_FLUSH;
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, eventName);
  return response;
}
async function forcemergeIndices(indices, maxNumSegments) {
  const body = JSON.stringify({
    indices,
    maxNumSegments
  });
  const response = await _http.httpService.httpClient.post(`${_constants.API_BASE_PATH}/indices/forcemerge`, {
    body
  });
  // Only track successful requests.
  const eventName = indices.length > 1 ? _constants.UIM_INDEX_FORCE_MERGE_MANY : _constants.UIM_INDEX_FORCE_MERGE;
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, eventName);
  return response;
}
async function clearCacheIndices(indices) {
  const body = JSON.stringify({
    indices
  });
  const response = await _http.httpService.httpClient.post(`${_constants.API_BASE_PATH}/indices/clear_cache`, {
    body
  });
  // Only track successful requests.
  const eventName = indices.length > 1 ? _constants.UIM_INDEX_CLEAR_CACHE_MANY : _constants.UIM_INDEX_CLEAR_CACHE;
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, eventName);
  return response;
}
async function unfreezeIndices(indices) {
  const body = JSON.stringify({
    indices
  });
  const response = await _http.httpService.httpClient.post(`${_constants.API_BASE_PATH}/indices/unfreeze`, {
    body
  });
  // Only track successful requests.
  const eventName = indices.length > 1 ? _constants.UIM_INDEX_UNFREEZE_MANY : _constants.UIM_INDEX_UNFREEZE;
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, eventName);
  return response;
}
async function loadIndexSettings(indexName) {
  const response = await _http.httpService.httpClient.get(`${_constants.API_BASE_PATH}/settings/${encodeURIComponent(indexName)}`);
  return response;
}
async function updateIndexSettings(indexName, body) {
  const response = await (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}/settings/${encodeURIComponent(indexName)}`,
    method: 'put',
    body: JSON.stringify(body)
  });

  // Only track successful requests.
  if (!response.error) {
    uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, _constants.UIM_UPDATE_SETTINGS);
  }
  return response;
}
async function loadIndexStats(indexName) {
  const response = await _http.httpService.httpClient.get(`${_constants.API_BASE_PATH}/stats/${encodeURIComponent(indexName)}`);
  return response;
}
async function loadIndexMapping(indexName) {
  const response = await _http.httpService.httpClient.get(`${_constants.API_BASE_PATH}/mapping/${encodeURIComponent(indexName)}`);
  return response;
}
function useLoadIndexTemplates() {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}/index_templates`,
    method: 'get'
  });
}
async function deleteTemplates(templates) {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}/delete_index_templates`,
    method: 'post',
    body: {
      templates
    }
  });
  const uimActionType = templates.length > 1 ? _constants.UIM_TEMPLATE_DELETE_MANY : _constants.UIM_TEMPLATE_DELETE;
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, uimActionType);
  return result;
}
function useLoadIndexTemplate(name, isLegacy) {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}/index_templates/${encodeURIComponent(name)}`,
    method: 'get',
    query: {
      legacy: isLegacy
    }
  });
}
async function saveTemplate(template, isClone) {
  const result = await (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}/index_templates`,
    method: 'post',
    body: JSON.stringify(template)
  });
  const uimActionType = isClone ? _constants.UIM_TEMPLATE_CLONE : _constants.UIM_TEMPLATE_CREATE;
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, uimActionType);
  return result;
}
async function updateTemplate(template) {
  const {
    name
  } = template;
  const result = await (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}/index_templates/${encodeURIComponent(name)}`,
    method: 'put',
    body: JSON.stringify(template)
  });
  uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, _constants.UIM_TEMPLATE_UPDATE);
  return result;
}
function simulateIndexTemplate(template) {
  return (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}/index_templates/simulate`,
    method: 'post',
    body: JSON.stringify(template)
  }).then(result => {
    uiMetricService.trackMetric(_analytics.METRIC_TYPE.COUNT, _constants.UIM_TEMPLATE_SIMULATE);
    return result;
  });
}
function useLoadNodesPlugins() {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}/nodes/plugins`,
    method: 'get'
  });
}
const useLoadEnrichPolicies = () => {
  return (0, _use_request.useRequest)({
    path: `${_constants.INTERNAL_API_BASE_PATH}/enrich_policies`,
    method: 'get'
  });
};
exports.useLoadEnrichPolicies = useLoadEnrichPolicies;
async function deleteEnrichPolicy(policyName) {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.INTERNAL_API_BASE_PATH}/enrich_policies/${policyName}`,
    method: 'delete'
  });
  return result;
}
async function executeEnrichPolicy(policyName) {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.INTERNAL_API_BASE_PATH}/enrich_policies/${policyName}`,
    method: 'put'
  });
  return result;
}
async function createEnrichPolicy(policy, executePolicyAfterCreation) {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.INTERNAL_API_BASE_PATH}/enrich_policies`,
    method: 'post',
    body: JSON.stringify({
      policy
    }),
    query: {
      executePolicyAfterCreation
    }
  });
  return result;
}
async function getMatchingIndices(pattern) {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.INTERNAL_API_BASE_PATH}/enrich_policies/get_matching_indices`,
    method: 'post',
    body: JSON.stringify({
      pattern
    })
  });
  return result;
}
async function getFieldsFromIndices(indices) {
  const result = (0, _use_request.sendRequest)({
    path: `${_constants.INTERNAL_API_BASE_PATH}/enrich_policies/get_fields_from_indices`,
    method: 'post',
    body: JSON.stringify({
      indices
    })
  });
  return result;
}
function loadIndex(indexName) {
  return (0, _use_request.sendRequest)({
    path: `${_constants.INTERNAL_API_BASE_PATH}/indices/${encodeURIComponent(indexName)}`,
    method: 'get'
  });
}
function useLoadIndexMappings(indexName) {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}/mapping/${encodeURIComponent(indexName)}`,
    method: 'get'
  });
}
function loadIndexStatistics(indexName) {
  return (0, _use_request.sendRequest)({
    path: `${_constants.API_BASE_PATH}/stats/${encodeURIComponent(indexName)}`,
    method: 'get'
  });
}
function useLoadIndexSettings(indexName) {
  return (0, _use_request.useRequest)({
    path: `${_constants.API_BASE_PATH}/settings/${encodeURIComponent(indexName)}`,
    method: 'get'
  });
}
function createIndex(indexName) {
  return (0, _use_request.sendRequest)({
    path: `${_constants.INTERNAL_API_BASE_PATH}/indices/create`,
    method: 'put',
    body: JSON.stringify({
      indexName
    })
  });
}