"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateClone = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _components = require("../../components");
var _breadcrumbs = require("../../services/breadcrumbs");
var _routing = require("../../services/routing");
var _api = require("../../services/api");
var _index_templates = require("../../lib/index_templates");
var _app_context = require("../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TemplateClone = ({
  match: {
    params: {
      name
    }
  },
  location,
  history
}) => {
  const decodedTemplateName = (0, _shared_imports.attemptToURIDecode)(name);
  const {
    config: {
      enableLegacyTemplates
    }
  } = (0, _app_context.useAppContext)();
  // We don't expect the `legacy` query to be used when legacy templates are disabled, however, we add the `enableLegacyTemplates` check as a safeguard
  const isLegacy = enableLegacyTemplates && (0, _index_templates.getIsLegacyFromQueryParams)(location);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const {
    error: templateToCloneError,
    data: templateToClone,
    isLoading
  } = (0, _api.useLoadIndexTemplate)(decodedTemplateName, isLegacy);
  const onSave = async template => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await (0, _api.saveTemplate)(template, true);
    const {
      name: newTemplateName
    } = template;
    setIsSaving(false);
    if (error) {
      setSaveError(error);
      return;
    }
    history.push((0, _routing.getTemplateDetailsLink)(newTemplateName, template._kbnMeta.isLegacy));
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.templateClone);
  }, []);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateCreate.loadingTemplateToCloneDescription",
      defaultMessage: "Loading template to clone\u2026"
    }));
  } else if (templateToCloneError) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateCreate.loadingTemplateToCloneErrorMessage",
        defaultMessage: "Error loading template to clone"
      }),
      error: templateToCloneError,
      "data-test-subj": "sectionError"
    });
  }
  const templateData = {
    ...templateToClone,
    name: `${decodedTemplateName}-copy`
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_components.TemplateForm, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.createTemplate.cloneTemplatePageTitle",
      defaultMessage: "Clone template '{name}'",
      values: {
        name: decodedTemplateName
      }
    }),
    defaultValue: templateData,
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    clearSaveError: clearSaveError,
    isLegacy: isLegacy,
    history: history
  }));
};
exports.TemplateClone = TemplateClone;