"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _data_stream_serialization = require("../../../../../../../common/lib/data_stream_serialization");
var _data_streams = require("../../../../../lib/data_streams");
var _constants = require("../../../../../constants");
var _use_ilm_locator = require("../../../../../services/use_ilm_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INFINITE_AS_ICON = true;
const i18nTexts = {
  yes: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTab.yesDescriptionText', {
    defaultMessage: 'Yes'
  }),
  no: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTab.noDescriptionText', {
    defaultMessage: 'No'
  }),
  none: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTab.noneDescriptionText', {
    defaultMessage: 'None'
  })
};
const TabSummary = ({
  templateDetails
}) => {
  const {
    version,
    priority,
    composedOf,
    order,
    indexPatterns = [],
    ilmPolicy,
    _meta,
    _kbnMeta: {
      isLegacy,
      hasDatastream
    },
    allowAutoCreate
  } = templateDetails;
  const numIndexPatterns = indexPatterns.length;
  const ilmPolicyLink = (0, _use_ilm_locator.useIlmLocator)(_constants.ILM_PAGES_POLICY_EDIT, ilmPolicy === null || ilmPolicy === void 0 ? void 0 : ilmPolicy.name);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "summaryTab"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.indexPatternsDescriptionListTitle",
    defaultMessage: "Index {numIndexPatterns, plural, one {pattern} other {patterns}}",
    values: {
      numIndexPatterns
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, numIndexPatterns > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("ul", null, indexPatterns.map((indexName, i) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: `${indexName}-${i}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("span", null, indexName)));
  }))) : indexPatterns.toString()), isLegacy !== true ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.priorityDescriptionListTitle",
    defaultMessage: "Priority"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, priority || priority === 0 ? priority : i18nTexts.none)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.orderDescriptionListTitle",
    defaultMessage: "Order"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, order || order === 0 ? order : i18nTexts.none)), isLegacy !== true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "componentsTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.componentsDescriptionListTitle",
    defaultMessage: "Component templates"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, composedOf && composedOf.length > 0 ? /*#__PURE__*/_react.default.createElement("ul", null, composedOf.map(component => /*#__PURE__*/_react.default.createElement("li", {
    key: component
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, component))))) : i18nTexts.none)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, isLegacy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.ilmPolicyDescriptionListTitle",
    defaultMessage: "ILM policy"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, ilmPolicy !== null && ilmPolicy !== void 0 && ilmPolicy.name && ilmPolicyLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: ilmPolicyLink
  }, ilmPolicy.name) : (ilmPolicy === null || ilmPolicy === void 0 ? void 0 : ilmPolicy.name) || i18nTexts.none)), isLegacy !== true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.dataStreamDescriptionListTitle",
    defaultMessage: "Data stream"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, hasDatastream ? i18nTexts.yes : i18nTexts.no)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.versionDescriptionListTitle",
    defaultMessage: "Version"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, version || version === 0 ? version : i18nTexts.none), hasDatastream && (templateDetails === null || templateDetails === void 0 ? void 0 : templateDetails.lifecycle) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.lifecycleDescriptionListTitle",
    defaultMessage: "Data retention"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, (0, _data_streams.getLifecycleValue)((0, _data_stream_serialization.serializeAsESLifecycle)(templateDetails.lifecycle), INFINITE_AS_ICON))), isLegacy !== true && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.allowAutoCreateDescriptionListTitle",
    defaultMessage: "Allow auto create"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, allowAutoCreate ? i18nTexts.yes : i18nTexts.no))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, isLegacy !== true && _meta && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "metaTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateDetails.summaryTab.metaDescriptionListTitle",
    defaultMessage: "Metadata"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json"
  }, JSON.stringify(_meta, null, 2))))));
};
exports.TabSummary = TabSummary;