"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _shared_imports = require("../../../../../shared_imports");
var _services = require("../../../../services");
var _breadcrumbs = require("../../../../services/breadcrumbs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsPageStats = ({
  indexName,
  isIndexOpen
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)();
  const [indexStats, setIndexStats] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.indexDetailsStats);
  }, []);
  const fetchIndexStats = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      const {
        data,
        error: loadingError
      } = await (0, _services.loadIndexStatistics)(indexName);
      setIsLoading(false);
      setError(loadingError);
      setIndexStats(data);
    } catch (e) {
      setIsLoading(false);
      setError(e);
    }
  }, [indexName]);
  (0, _react.useEffect)(() => {
    if (isIndexOpen) {
      fetchIndexStats();
    }
  }, [fetchIndexStats, isIndexOpen]);
  if (isIndexOpen === false) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      "data-test-subj": "indexStatsNotAvailableWarning",
      iconType: "warning",
      color: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.stats.statsNotAvailableTitle",
        defaultMessage: "Index statistics not available"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.stats.statsNotAvailableDescription",
        defaultMessage: "To view index statistics, verify your index is open."
      }))
    });
  }
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.stats.loadingIndexStats",
      defaultMessage: "Loading index statistics\u2026"
    }));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      "data-test-subj": "indexDetailsStatsError",
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.stats.errorTitle",
        defaultMessage: "Unable to load index statistics"
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.stats.errorDescription",
        defaultMessage: "We encountered an error loading statistics for index {indexName}. Make sure that the index name in the URL is correct and try again.",
        values: {
          indexName
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconSide: "right",
        onClick: fetchIndexStats,
        iconType: "refresh",
        color: "danger",
        "data-test-subj": "reloadIndexStatsButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.stats.reloadButtonLabel",
        defaultMessage: "Reload"
      })))
    });
  }
  if (indexStats) {
    // using "rowReverse" to keep docs links on the top of the stats code block on smaller screen
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      direction: "rowReverse",
      css: (0, _react2.css)`
          height: 100%;
        `,
      "data-test-subj": "statsTabContent"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      css: (0, _react2.css)`
            min-width: 400px;
          `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: false,
      paddingSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.stats.indexStatsTitle",
      defaultMessage: "About index statistics"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.stats.indexStatsDescription",
      defaultMessage: "Index stats contain high-level aggregation and statistics for an index. The {primariesField} field represents the values for only primary shards, and the {totalField} field contains the accumulated values for both primary and replica shards.",
      values: {
        primariesField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "primaries"),
        totalField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "total")
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "indexDetailsStatsDocsLink",
      href: _services.documentationService.getIndexStats(),
      target: "_blank",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.stats.learnMoreLink",
      defaultMessage: "Learn more about statistics"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 3,
      css: (0, _react2.css)`
            min-width: 600px;
          `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      "data-test-subj": "indexDetailsStatsCodeBlock",
      isCopyable: true,
      language: "json",
      paddingSize: "m",
      css: (0, _react2.css)`
                height: 100%;
              `
    }, JSON.stringify(indexStats, null, 2)))));
  }
  return null;
};
exports.DetailsPageStats = DetailsPageStats;