"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageMappingsContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _services = require("../../../../services");
var _app_context = require("../../../../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsPageMappingsContent = ({
  index,
  data
}) => {
  const {
    services: {
      extensionsService
    },
    core: {
      getUrlForApp
    }
  } = (0, _app_context.useAppContext)();
  return (
    /*#__PURE__*/
    // using "rowReverse" to keep docs links on the top of the mappings code block on smaller screen
    _react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      direction: "rowReverse",
      css: (0, _react2.css)`
        height: 100%;
      `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      css: (0, _react2.css)`
          min-width: 400px;
        `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: false,
      paddingSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.docsCardTitle",
      defaultMessage: "About index mappings"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.docsCardDescription",
      defaultMessage: "Your documents are made up of a set of fields. Index mappings give each field a type (such as keyword, number, or date) and additional subfields. These index mappings determine the functions available in your relevance tuning and search experience."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "indexDetailsMappingsDocsLink",
      href: _services.documentationService.getMappingDocumentationLink(),
      target: "_blank",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.docsCardLink",
      defaultMessage: "Learn more about mappings"
    }))), extensionsService.indexMappingsContent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), extensionsService.indexMappingsContent.renderContent({
      index,
      getUrlForApp
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 3,
      css: (0, _react2.css)`
          min-width: 600px;
        `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true,
      "data-test-subj": "indexDetailsMappingsCodeBlock",
      css: (0, _react2.css)`
              height: 100%;
            `
    }, JSON.stringify(data, null, 2)))))
  );
};
exports.DetailsPageMappingsContent = DetailsPageMappingsContent;