"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _render_badges = require("../../../../lib/render_badges");
var _constants = require("../../../../../../common/constants");
var _routing = require("../../../../services/routing");
var _app_context = require("../../../../app_context");
var _discover_link = require("../../../../lib/discover_link");
var _manage_index_button = require("./manage_index_button");
var _details_page_overview = require("./details_page_overview");
var _details_page_mappings = require("./details_page_mappings");
var _details_page_settings = require("./details_page_settings");
var _details_page_stats = require("./details_page_stats");
var _details_page_tab = require("./details_page_tab");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultTabs = [{
  id: _constants.IndexDetailsSection.Overview,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.overviewTitle",
    defaultMessage: "Overview"
  }),
  renderTabContent: ({
    index
  }) => /*#__PURE__*/_react.default.createElement(_details_page_overview.DetailsPageOverview, {
    indexDetails: index
  }),
  order: 10
}, {
  id: _constants.IndexDetailsSection.Mappings,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.mappingsTitle",
    defaultMessage: "Mappings"
  }),
  renderTabContent: ({
    index
  }) => /*#__PURE__*/_react.default.createElement(_details_page_mappings.DetailsPageMappings, {
    index: index
  }),
  order: 20
}, {
  id: _constants.IndexDetailsSection.Settings,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.settingsTitle",
    defaultMessage: "Settings"
  }),
  renderTabContent: ({
    index
  }) => /*#__PURE__*/_react.default.createElement(_details_page_settings.DetailsPageSettings, {
    indexName: index.name,
    isIndexOpen: index.status === _constants.INDEX_OPEN
  }),
  order: 30
}];
const statsTab = {
  id: _constants.IndexDetailsSection.Stats,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.statsTitle",
    defaultMessage: "Statistics"
  }),
  renderTabContent: ({
    index
  }) => /*#__PURE__*/_react.default.createElement(_details_page_stats.DetailsPageStats, {
    indexName: index.name,
    isIndexOpen: index.status === _constants.INDEX_OPEN
  }),
  order: 40
};
const DetailsPageContent = ({
  index,
  tab,
  history,
  fetchIndexDetails
}) => {
  const {
    config: {
      enableIndexStats
    },
    services: {
      extensionsService
    }
  } = (0, _app_context.useAppContext)();
  const tabs = (0, _react.useMemo)(() => {
    const sortedTabs = [...defaultTabs];
    if (enableIndexStats) {
      sortedTabs.push(statsTab);
    }
    extensionsService.indexDetailsTabs.forEach(dynamicTab => {
      if (!dynamicTab.shouldRenderTab || dynamicTab.shouldRenderTab({
        index
      })) {
        sortedTabs.push(dynamicTab);
      }
    });
    sortedTabs.sort((tabA, tabB) => {
      return tabA.order - tabB.order;
    });
    return sortedTabs;
  }, [enableIndexStats, extensionsService.indexDetailsTabs, index]);
  const onSectionChange = (0, _react.useCallback)(newSection => {
    return history.push((0, _routing.getIndexDetailsLink)(index.name, newSection));
  }, [history, index]);
  const navigateToAllIndices = (0, _react.useCallback)(() => {
    history.push(`/${_constants.Section.Indices}`);
  }, [history]);
  const headerTabs = (0, _react.useMemo)(() => {
    return tabs.map(tabConfig => ({
      onClick: () => onSectionChange(tabConfig.id),
      isSelected: tabConfig.id === tab,
      key: tabConfig.id,
      'data-test-subj': `indexDetailsTab-${tabConfig.id}`,
      label: tabConfig.name
    }));
  }, [tabs, tab, onSectionChange]);
  const pageTitle = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index.name, (0, _render_badges.renderBadges)(index, extensionsService));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "indexDetailsBackToIndicesButton",
    color: "text",
    iconType: "arrowLeft",
    onClick: navigateToAllIndices
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.backToIndicesButtonLabel",
    defaultMessage: "Back to all indices"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "indexDetailsHeader",
    pageTitle: pageTitle,
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_discover_link.DiscoverLink, {
      indexName: index.name,
      asButton: true
    }), /*#__PURE__*/_react.default.createElement(_manage_index_button.ManageIndexButton, {
      index: index,
      reloadIndexDetails: fetchIndexDetails,
      navigateToAllIndices: navigateToAllIndices
    })],
    rightSideGroupProps: {
      wrap: false
    },
    responsive: "reverse",
    tabs: headerTabs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `indexDetailsContent`,
    css: (0, _react2.css)`
          height: 100%;
        `
  }, /*#__PURE__*/_react.default.createElement(_details_page_tab.DetailsPageTab, {
    tabs: tabs,
    tab: tab,
    index: index
  })));
};
exports.DetailsPageContent = DetailsPageContent;