"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyState = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _app_context = require("../../../../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyState = () => {
  const {
    history
  } = (0, _app_context.useAppContext)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
    iconType: "managementApp",
    "data-test-subj": "sectionEmpty",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicies.list.emptyPromptTitle",
      defaultMessage: "Add your first enrich policy"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicies.list.emptyPromptDescription",
      defaultMessage: "Use an enrich policy to add data from existing indices into incoming documents during ingest."
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      fill: true,
      iconType: "plusInCircle",
      "data-test-subj": "enrichPoliciesEmptyPromptCreateButton"
    }, (0, _public.reactRouterNavigate)(history, '/enrich_policies/create')), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicies.list.emptyPromptButtonLabel",
      defaultMessage: "Add an enrich policy"
    }))
  });
};
exports.EmptyState = EmptyState;