"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPrompt = ({
  createField,
  runtimeFieldsDocsUri
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "managementApp",
    "data-test-subj": "emptyList",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      "data-test-subj": "title"
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.runtimeFields.emptyPromptTitle', {
      defaultMessage: 'Start by creating a runtime field'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.runtimeFields.emptyPromptDescription",
      defaultMessage: "Define a field in the mapping and evaluate it at search time."
    }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: runtimeFieldsDocsUri,
      target: "_blank",
      "data-test-subj": "learnMoreLink",
      external: true
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.runtimeFields.emptyPromptDocumentionLink', {
      defaultMessage: 'Learn more.'
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => createField(),
      iconType: "plusInCircle",
      "data-test-subj": "createRuntimeFieldButton",
      fill: true
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.runtimeFields.emptyPromptButtonLabel', {
      defaultMessage: 'Create runtime field'
    }))
  });
};
exports.EmptyPrompt = EmptyPrompt;