"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../services/documentation");
var _lib = require("../../../lib");
var _shared_imports = require("../../../shared_imports");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TypeParameter = ({
  isMultiField,
  isRootLevelField,
  showDocLink = false
}) => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: "type",
  config: (0, _lib.getFieldConfig)('type')
}, typeField => {
  const error = typeField.getErrorsMessages();
  const isInvalid = error ? Boolean(error.length) : false;
  let docLink = null;
  if (showDocLink && typeField.value.length > 0) {
    const selectedType = typeField.value[0].value;
    docLink = _documentation.documentationService.getTypeDocLink(selectedType);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: typeField.label,
    error: error,
    isInvalid: isInvalid,
    helpText: docLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLink,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.typeField.documentationLinkLabel', {
      defaultMessage: '{typeName} documentation',
      values: {
        typeName: typeField.value && typeField.value[0] ? typeField.value[0].label : ''
      }
    }))) : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.typeField.placeholderLabel', {
      defaultMessage: 'Select a type'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: isMultiField ? (0, _lib.filterTypesForMultiField)(_constants.FIELD_TYPES_OPTIONS) : isRootLevelField ? _constants.FIELD_TYPES_OPTIONS : (0, _lib.filterTypesForNonRootFields)(_constants.FIELD_TYPES_OPTIONS),
    selectedOptions: typeField.value,
    onChange: value => {
      if (value.length === 0) {
        // Don't allow clearing the type. One must always be selected
        return;
      }
      typeField.setValue(value);
    },
    isClearable: false,
    "data-test-subj": "fieldType"
  }));
});
exports.TypeParameter = TypeParameter;