"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtherTypeNameParameter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is a special component that does not have an explicit entry in {@link PARAMETERS_DEFINITION}.
 *
 * We use it to store the name of types unknown to the mappings editor in the "subType" path.
 */

const typeParameterConfig = (0, _lib.getFieldConfig)('type');
const fieldConfig = {
  label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.otherTypeNameFieldLabel', {
    defaultMessage: 'Type Name'
  }),
  defaultValue: '',
  deserializer: typeParameterConfig.deserializer,
  serializer: typeParameterConfig.serializer,
  validations: [{
    validator: ({
      value: fieldValue
    }) => {
      if (fieldValue[0].value.trim() === '') {
        return {
          message: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.validations.otherTypeNameIsRequiredErrorMessage', {
            defaultMessage: 'The type name is required.'
          })
        };
      }
    }
  }]
};
/**
 * The "subType" parameter can be configured either with a ComboBox (when the type is known)
 * or with a TextField (when the type is unknown). This causes its value to have different type
 * (either an array of object either a string). In order to align both value and let the consumer of
 * the value worry about a single type, we will create a custom TextField component that works with the
 * array of object that the ComboBox works with.
 */
const CustomTextField = ({
  field
}) => {
  var _field$value$0$value, _field$value$;
  const {
    setValue
  } = field;
  const transformedField = {
    ...field,
    value: (_field$value$0$value = (_field$value$ = field.value[0]) === null || _field$value$ === void 0 ? void 0 : _field$value$.value) !== null && _field$value$0$value !== void 0 ? _field$value$0$value : ''
  };
  const onChange = (0, _react.useCallback)(e => {
    setValue([{
      value: e.target.value
    }]);
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.TextField, {
    field: transformedField,
    euiFieldProps: {
      onChange,
      'data-test-subj': 'fieldSubType'
    }
  });
};
const OtherTypeNameParameter = () => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: "subType",
  config: fieldConfig,
  component: CustomTextField
});
exports.OtherTypeNameParameter = OtherTypeNameParameter;