"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplatesWithPrivileges = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../shared_imports");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentTemplatesWithPrivileges = ({
  children
}) => {
  const {
    apiError
  } = (0, _shared_imports.useAuthorizationContext)();
  if (apiError) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.home.componentTemplates.checkingPrivilegesErrorMessage",
        defaultMessage: "Error fetching user privileges from the server."
      }),
      error: apiError
    });
  }
  return /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
    privileges: _constants.APP_CLUSTER_REQUIRED_PRIVILEGES.map(privilege => `cluster.${privilege}`)
  }, ({
    isLoading,
    hasPrivileges,
    privilegesMissing
  }) => {
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.home.componentTemplates.checkingPrivilegesDescription",
        defaultMessage: "Checking privileges\u2026"
      }));
    }
    if (!hasPrivileges) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.NotAuthorizedSection, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.home.componentTemplates.deniedPrivilegeTitle",
          defaultMessage: "Cluster privileges required"
        }),
        message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.home.componentTemplates.deniedPrivilegeDescription",
          defaultMessage: "To use Component Templates, you must have {privilegesCount, plural, one {this cluster privilege} other {these cluster privileges}}: {missingPrivileges}.",
          values: {
            missingPrivileges: privilegesMissing.cluster.join(', '),
            privilegesCount: privilegesMissing.cluster.length
          }
        })
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  });
};
exports.ComponentTemplatesWithPrivileges = ComponentTemplatesWithPrivileges;