"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _policy_list = require("./policy_list");
var _shared_imports = require("../../../shared_imports");
var _api = require("../../services/api");
var _policy_list_context = require("./policy_list_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyList = () => {
  const {
    services: {
      breadcrumbService
    }
  } = (0, _shared_imports.useKibana)();
  const {
    data: policies,
    isLoading,
    error,
    resendRequest
  } = (0, _api.useLoadPoliciesList)();
  (0, _react.useEffect)(() => {
    breadcrumbService.setBreadcrumbs('policies');
  }, [breadcrumbService]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl"
      }),
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.policiesLoading",
        defaultMessage: "Loading policies..."
      })
    });
  }
  if (error) {
    const {
      statusCode,
      message
    } = error ? error : {
      statusCode: '',
      message: ''
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.policiesLoadingFailedTitle",
        defaultMessage: "Unable to load existing lifecycle policies"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, message, " (", statusCode, ")"),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.policiesReloadButton",
        defaultMessage: "Try again"
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_policy_list_context.PolicyListContextProvider, null, /*#__PURE__*/_react.default.createElement(_policy_list.PolicyList, {
    policies: policies || [],
    updatePolicies: resendRequest
  }));
};
exports.PolicyList = PolicyList;