"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePhaseTimings = exports.PhaseTimingsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPhaseTimingConfiguration = formData => {
  var _formData$_meta, _formData$_meta$warm, _formData$_meta2, _formData$_meta2$cold, _formData$_meta3, _formData$_meta3$froz;
  const isWarmPhaseEnabled = formData === null || formData === void 0 ? void 0 : (_formData$_meta = formData._meta) === null || _formData$_meta === void 0 ? void 0 : (_formData$_meta$warm = _formData$_meta.warm) === null || _formData$_meta$warm === void 0 ? void 0 : _formData$_meta$warm.enabled;
  const isColdPhaseEnabled = formData === null || formData === void 0 ? void 0 : (_formData$_meta2 = formData._meta) === null || _formData$_meta2 === void 0 ? void 0 : (_formData$_meta2$cold = _formData$_meta2.cold) === null || _formData$_meta2$cold === void 0 ? void 0 : _formData$_meta2$cold.enabled;
  const isFrozenPhaseEnabled = formData === null || formData === void 0 ? void 0 : (_formData$_meta3 = formData._meta) === null || _formData$_meta3 === void 0 ? void 0 : (_formData$_meta3$froz = _formData$_meta3.frozen) === null || _formData$_meta3$froz === void 0 ? void 0 : _formData$_meta3$froz.enabled;
  return {
    hot: {
      isFinalDataPhase: !isWarmPhaseEnabled && !isColdPhaseEnabled && !isFrozenPhaseEnabled
    },
    warm: {
      isFinalDataPhase: isWarmPhaseEnabled && !isColdPhaseEnabled && !isFrozenPhaseEnabled
    },
    cold: {
      isFinalDataPhase: isColdPhaseEnabled && !isFrozenPhaseEnabled
    },
    frozen: {
      isFinalDataPhase: isFrozenPhaseEnabled
    }
  };
};
const PhaseTimingsContext = /*#__PURE__*/(0, _react.createContext)(null);
const PhaseTimingsProvider = ({
  children
}) => {
  const {
    deleteEnabled
  } = (0, _.useGlobalFields)();
  const [formData] = (0, _shared_imports.useFormData)({
    watch: ['_meta.warm.enabled', '_meta.cold.enabled', '_meta.frozen.enabled', '_meta.delete.enabled']
  });
  return /*#__PURE__*/_react.default.createElement(PhaseTimingsContext.Provider, {
    value: {
      ...getPhaseTimingConfiguration(formData),
      isDeletePhaseEnabled: deleteEnabled.value,
      setDeletePhaseEnabled: deleteEnabled.setValue
    }
  }, children);
};
exports.PhaseTimingsProvider = PhaseTimingsProvider;
const usePhaseTimings = () => {
  const ctx = (0, _react.useContext)(PhaseTimingsContext);
  if (!ctx) throw new Error('Cannot use phase timings outside of phase timings context');
  return ctx;
};
exports.usePhaseTimings = usePhaseTimings;