"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownsampleField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _unit_field = require("./unit_field");
var _constants = require("../../../constants");
var _form = require("../../../form");
var _shared_imports = require("../../../../../../shared_imports");
var _described_form_row = require("../../described_form_row");
var _i18n_texts = require("../../../i18n_texts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// import { LearnMoreLink } from '../../learn_more_link';

const DownsampleField = ({
  phase
}) => {
  // const { docLinks } = useKibana().services;

  const downsampleEnabledPath = `_meta.${phase}.downsample.enabled`;
  const downsampleIntervalSizePath = `_meta.${phase}.downsample.fixedIntervalSize`;
  const downsampleIntervalUnitsPath = `_meta.${phase}.downsample.fixedIntervalUnits`;
  return /*#__PURE__*/_react.default.createElement(_described_form_row.ToggleFieldWithDescribedFormRow, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.downsampleTitle",
      defaultMessage: "Downsample"
    })),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.downsampleDescription",
      defaultMessage: "Roll up documents within a fixed interval to a single summary document. Reduces the index footprint by storing time series data at reduced granularity."
    }), ' '),
    fullWidth: true,
    titleSize: "xs",
    switchProps: {
      'data-test-subj': `${phase}-downsampleSwitch`,
      path: downsampleEnabledPath
    }
  }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: downsampleIntervalSizePath,
    key: downsampleIntervalSizePath,
    component: _shared_imports.NumericField,
    componentProps: {
      fullWidth: false,
      euiFieldProps: {
        'data-test-subj': `${phase}-downsampleFixedInterval`,
        min: 1,
        append: /*#__PURE__*/_react.default.createElement(_unit_field.UnitField, {
          path: downsampleIntervalUnitsPath,
          options: _constants.timeUnits,
          euiFieldProps: {
            'data-test-subj': `${phase}-downsampleFixedIntervalUnits`,
            'aria-label': _i18n_texts.i18nTexts.editPolicy.downsampleIntervalFieldUnitsLabel
          }
        })
      }
    }
  }));
};
exports.DownsampleField = DownsampleField;