"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configureImage = configureImage;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _operators = require("rxjs/operators");
var _rxjs = require("rxjs");
var _image_editor_flyout = require("./image_editor_flyout");
var _image_viewer = require("../image_viewer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @throws in case user cancels
 */
async function configureImage(deps, initialImageConfig) {
  return new Promise((resolve, reject) => {
    const closed$ = new _rxjs.Subject();
    const onSave = imageConfig => {
      resolve(imageConfig);
      handle.close();
    };
    const onCancel = () => {
      reject();
      handle.close();
    };

    // Close the flyout on application change.
    deps.currentAppId$.pipe((0, _operators.takeUntil)(closed$), (0, _operators.skip)(1), (0, _operators.take)(1)).subscribe(() => {
      handle.close();
    });
    const handle = deps.overlays.openFlyout((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_sharedUxFileContext.FilesContext, {
      client: deps.files
    }, /*#__PURE__*/_react.default.createElement(_image_viewer.ImageViewerContext.Provider, {
      value: {
        getImageDownloadHref: deps.getImageDownloadHref,
        validateUrl: deps.validateUrl
      }
    }, /*#__PURE__*/_react.default.createElement(_image_editor_flyout.ImageEditorFlyout, {
      onCancel: onCancel,
      onSave: onSave,
      initialImageConfig: initialImageConfig,
      validateUrl: deps.validateUrl,
      user: deps.user
    }))), {
      theme$: deps.theme.theme$
    }), {
      ownFocus: true,
      'data-test-subj': 'createImageEmbeddableFlyout'
    });
    handle.onClose.then(() => {
      closed$.next(true);
    });
  });
}