"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @public */

class EnvironmentService {
  constructor() {
    (0, _defineProperty2.default)(this, "environment", {
      cloud: false,
      apmUi: false,
      ml: false
    });
  }
  setup() {
    return {
      /**
       * Update the environment to influence how the home app is presenting available features.
       * This API should not be extended for new features and will be removed in future versions
       * in favor of display specific extension apis.
       * @deprecated
       * @removeBy 8.8.0
       * @param update
       */
      update: update => {
        this.environment = Object.assign({}, this.environment, update);
      }
    };
  }
  getEnvironment() {
    return this.environment;
  }
}
exports.EnvironmentService = EnvironmentService;