"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installSampleDataSet = installSampleDataSet;
exports.listSampleDataSets = listSampleDataSets;
exports.uninstallSampleDataSet = uninstallSampleDataSet;
var _kibana_services = require("./kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const sampleDataUrl = '/api/sample_data';
function clearIndexPatternsCache() {
  (0, _kibana_services.getServices)().dataViewsService.clearCache();
}
async function listSampleDataSets() {
  return await (0, _kibana_services.getServices)().http.get(sampleDataUrl);
}
async function installSampleDataSet(id, sampleDataDefaultIndex) {
  await (0, _kibana_services.getServices)().http.post(`${sampleDataUrl}/${id}`);
  if ((0, _kibana_services.getServices)().uiSettings.isDefault('defaultIndex')) {
    (0, _kibana_services.getServices)().uiSettings.set('defaultIndex', sampleDataDefaultIndex);
  }
  clearIndexPatternsCache();
}
async function uninstallSampleDataSet(id, sampleDataDefaultIndex) {
  await (0, _kibana_services.getServices)().http.delete(`${sampleDataUrl}/${id}`);
  const uiSettings = (0, _kibana_services.getServices)().uiSettings;
  if (!uiSettings.isDefault('defaultIndex') && uiSettings.get('defaultIndex') === sampleDataDefaultIndex) {
    uiSettings.set('defaultIndex', null);
  }
  clearIndexPatternsCache();
}