"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTutorial = getTutorial;
exports.getTutorials = getTutorials;
var _lodash = _interopRequireDefault(require("lodash"));
var _kibana_services = require("./kibana_services");
var _i18n = require("@kbn/i18n");
var _coreHttpCommon = require("@kbn/core-http-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const baseUrl = (0, _kibana_services.getServices)().addBasePath('/api/kibana/home/tutorials');
const headers = new Headers();
headers.append('Accept', 'application/json');
headers.append('Content-Type', 'application/json');
headers.append('kbn-xsrf', 'kibana');
headers.append(_coreHttpCommon.X_ELASTIC_INTERNAL_ORIGIN_REQUEST, 'kibana');
let tutorials = [];
let tutorialsLoaded = false;
async function loadTutorials() {
  try {
    const response = await fetch(baseUrl, {
      method: 'get',
      credentials: 'include',
      headers: headers
    });
    if (response.status >= 300) {
      throw new Error(_i18n.i18n.translate('home.loadTutorials.requestFailedErrorMessage', {
        defaultMessage: 'Request failed with status code: {status}',
        values: {
          status: response.status
        }
      }));
    }
    tutorials = await response.json();
    tutorialsLoaded = true;
  } catch (err) {
    (0, _kibana_services.getServices)().toastNotifications.addDanger({
      title: _i18n.i18n.translate('home.loadTutorials.unableToLoadErrorMessage', {
        defaultMessage: 'Unable to load tutorials'
      }),
      text: err.message
    });
  }
}
async function getTutorials() {
  if (!tutorialsLoaded) {
    await loadTutorials();
  }
  return _lodash.default.cloneDeep(tutorials);
}
async function getTutorial(id) {
  if (!tutorialsLoaded) {
    await loadTutorials();
  }
  const tutorial = tutorials.find(tutorial => {
    return tutorial.id === id;
  });
  if (tutorial) {
    return _lodash.default.cloneDeep(tutorial);
  }
}