"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MoveData = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MoveData = ({
  addBasePath
}) => {
  const migrateDataUrl = 'https://ela.st/cloud-migration';
  const buttonLabel = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "home.addData.moveYourDataButtonLabel",
    defaultMessage: "Move to Elastic Cloud"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: _i18n.i18n.translate('home.moveData.illustration.alt.text', {
      defaultMessage: 'Illustration for cloud data migration'
    }),
    src: addBasePath('/plugins/kibanaReact/assets/') + 'illustration_cloud_migration.png'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "home.addData.moveYourDataTitle",
    defaultMessage: "Try managed Elastic"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "home.addData.moveYourDataToElasticCloud",
    defaultMessage: "Deploy, scale, and upgrade your stack faster with Elastic Cloud. We\u2019ll help you quickly move your data."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "migrate_data_to_cloud__migrate_data_docs_link",
    color: "primary",
    href: migrateDataUrl,
    target: "_blank"
  }, buttonLabel))));
};
exports.MoveData = MoveData;