"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HomeApp = HomeApp;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _home = require("./home");
var _tutorial_directory = require("./tutorial_directory");
var _tutorial = require("./tutorial/tutorial");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _load_tutorials = require("../load_tutorials");
var _replace_template_strings = require("./tutorial/replace_template_strings");
var _kibana_services = require("../kibana_services");
var _guided_onboarding = require("./guided_onboarding");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const REDIRECT_TO_INTEGRATIONS_TAB_IDS = ['all', 'logging', 'metrics', 'security'];
function HomeApp({
  directories,
  solutions
}) {
  const {
    application,
    savedObjectsClient,
    getBasePath,
    addBasePath,
    environmentService,
    dataViewsService,
    guidedOnboardingService
  } = (0, _kibana_services.getServices)();
  const environment = environmentService.getEnvironment();
  const isCloudEnabled = environment.cloud;
  const renderTutorialDirectory = props => {
    // Redirect to integrations app unless a specific tab that is still supported was specified.
    const tabId = props.match.params.tab;
    if (!tabId || REDIRECT_TO_INTEGRATIONS_TAB_IDS.includes(tabId)) {
      application.navigateToApp('integrations', {
        replace: true
      });
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_tutorial_directory.TutorialDirectory, {
      addBasePath: addBasePath,
      openTab: tabId,
      isCloudEnabled: isCloudEnabled
    });
  };
  const renderTutorial = props => {
    return /*#__PURE__*/_react.default.createElement(_tutorial.Tutorial, {
      addBasePath: addBasePath,
      isCloudEnabled: isCloudEnabled,
      getTutorial: _load_tutorials.getTutorial,
      replaceTemplateStrings: _replace_template_strings.replaceTemplateStrings,
      tutorialId: props.match.params.id,
      bulkCreate: savedObjectsClient.bulkCreate
    });
  };
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.HashRouter, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/tutorial/:id",
    render: renderTutorial
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/tutorial_directory/:tab?",
    render: renderTutorialDirectory
  }), (guidedOnboardingService === null || guidedOnboardingService === void 0 ? void 0 : guidedOnboardingService.isEnabled) && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/getting_started"
  }, /*#__PURE__*/_react.default.createElement(_guided_onboarding.GettingStarted, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(_home.Home, {
    addBasePath: addBasePath,
    directories: directories,
    solutions: solutions,
    localStorage: localStorage,
    urlBasePath: getBasePath(),
    hasUserDataView: () => dataViewsService.hasUserDataView(),
    isCloudEnabled: isCloudEnabled
  })), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: "/"
  }))));
}
HomeApp.propTypes = {
  directories: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired,
    subtitle: _propTypes.default.string,
    description: _propTypes.default.string.isRequired,
    icon: _propTypes.default.string.isRequired,
    path: _propTypes.default.string.isRequired,
    showOnHomePage: _propTypes.default.bool.isRequired,
    category: _propTypes.default.string.isRequired,
    order: _propTypes.default.number,
    solutionId: _propTypes.default.string
  })),
  solutions: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired,
    description: _propTypes.default.string,
    icon: _propTypes.default.string.isRequired,
    path: _propTypes.default.string.isRequired,
    order: _propTypes.default.number
  }))
};