"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGraphStore = void 0;
exports.createRootReducer = createRootReducer;
var _reduxSaga = _interopRequireDefault(require("redux-saga"));
var _redux = require("redux");
var _fields = require("./fields");
var _url_templates = require("./url_templates");
var _advanced_settings = require("./advanced_settings");
var _datasource = require("./datasource");
var _datasource2 = require("./datasource.sagas");
var _persistence = require("./persistence");
var _meta_data = require("./meta_data");
var _workspace = require("./workspace");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createRootReducer(addBasePath) {
  return (0, _redux.combineReducers)({
    fields: _fields.fieldsReducer,
    urlTemplates: (0, _url_templates.urlTemplatesReducer)(addBasePath),
    advancedSettings: _advanced_settings.advancedSettingsReducer,
    datasource: _datasource.datasourceReducer,
    metaData: _meta_data.metaDataReducer,
    workspace: _workspace.workspaceReducer
  });
}
function registerSagas(sagaMiddleware, deps) {
  sagaMiddleware.run((0, _datasource2.datasourceSaga)(deps));
  sagaMiddleware.run((0, _persistence.loadingSaga)(deps));
  sagaMiddleware.run((0, _persistence.savingSaga)(deps));
  sagaMiddleware.run((0, _fields.syncFieldsSaga)(deps));
  sagaMiddleware.run((0, _fields.syncNodeStyleSaga)(deps));
  sagaMiddleware.run((0, _advanced_settings.syncSettingsSaga)(deps));
  sagaMiddleware.run((0, _fields.updateSaveButtonSaga)(deps));
  sagaMiddleware.run((0, _meta_data.syncBreadcrumbSaga)(deps));
  sagaMiddleware.run((0, _url_templates.syncTemplatesSaga)(deps));
  sagaMiddleware.run((0, _workspace.fillWorkspaceSaga)(deps));
  sagaMiddleware.run((0, _workspace.submitSearchSaga)(deps));
}
const createGraphStore = deps => {
  const sagaMiddleware = (0, _reduxSaga.default)();
  const rootReducer = createRootReducer(deps.addBasePath);
  const store = (0, _redux.createStore)(rootReducer, (0, _redux.applyMiddleware)(sagaMiddleware));
  registerSagas(sagaMiddleware, deps);
  return store;
};
exports.createGraphStore = createGraphStore;