"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldManager = void 0;
exports.FieldManagerComponent = FieldManagerComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _redux = require("redux");
var _reactRedux = require("react-redux");
var _field_picker = require("./field_picker");
var _field_editor = require("./field_editor");
var _state_management = require("../../state_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldManagerComponent(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "gphFieldManager",
    gutterSize: "s",
    alignItems: "center",
    wrap: true,
    responsive: false
  }, props.selectedFields.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: field.name,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_field_editor.FieldEditor, (0, _extends2.default)({}, props, {
    field: field
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_field_picker.FieldPicker, (0, _extends2.default)({}, props, {
    open: props.pickerOpen,
    setOpen: props.setPickerOpen
  }))));
}
const FieldManager = (0, _reactRedux.connect)(state => ({
  fieldMap: (0, _state_management.fieldMapSelector)(state),
  allFields: (0, _state_management.fieldsSelector)(state),
  selectedFields: (0, _state_management.selectedFieldsSelector)(state)
}), dispatch => (0, _redux.bindActionCreators)({
  updateFieldProperties: _state_management.updateFieldProperties,
  selectField: _state_management.selectField,
  deselectField: _state_management.deselectField
}, dispatch))(FieldManagerComponent);
exports.FieldManager = FieldManager;