"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resultToOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _result_tag_list = require("../components/result_tag_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cleanMeta = str => (str.charAt(0).toUpperCase() + str.slice(1)).replace(/-/g, ' ');
const resultToOption = (result, searchTagIds, getTag) => {
  var _ref;
  const {
    id,
    title,
    url,
    icon,
    type,
    meta = {}
  } = result;
  const {
    tagIds = [],
    categoryLabel = ''
  } = meta;
  // only displaying icons for applications and integrations
  const useIcon = type === 'application' || type === 'integration' || type.toLowerCase() === 'enterprise search' || type.toLowerCase() === 'search';
  const option = {
    key: id,
    label: title,
    url,
    type,
    icon: {
      type: useIcon && icon ? icon : 'empty'
    },
    'data-test-subj': `nav-search-option`
  };
  option.meta = type === 'application' ? [{
    text: categoryLabel
  }] : [{
    text: cleanMeta((_ref = meta.displayName) !== null && _ref !== void 0 ? _ref : type)
  }];
  if (getTag && tagIds.length) {
    const tags = tagIds.map(getTag).filter((tag, index) => {
      if (!tag) {
        // eslint-disable-next-line no-console
        console.warn(`SearchBar: Tag with id "${tagIds[index]}" not found. Tag "${tagIds[index]}" is referenced by the search result "${result.type}:${result.id}". Skipping displaying the missing tag.`);
        return false;
      }
      return true;
    });
    if (tags.length) {
      // TODO #85189 - refactor to use TagList instead of getTag
      option.append = /*#__PURE__*/_react.default.createElement(_result_tag_list.ResultTagList, {
        tags: tags,
        searchTagIds: searchTagIds
      });
    }
  }
  return option;
};
exports.resultToOption = resultToOption;