"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverPlaceholder = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverPlaceholder = ({
  basePath,
  darkMode
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      minHeight: 300
    },
    "data-test-subj": "nav-search-no-results",
    direction: "column",
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: _i18n.i18n.translate('xpack.globalSearchBar.searchBar.noResultsImageAlt', {
      defaultMessage: 'Illustration of black hole'
    }),
    size: "fullWidth",
    url: `${basePath}illustration_product_no_search_results_${darkMode ? 'dark' : 'light'}.svg`
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.globalSearchBar.searchBar.noResultsHeading",
    defaultMessage: "No results found"
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.globalSearchBar.searchBar.noResults",
    defaultMessage: "Try searching for applications, dashboards, visualizations, and more."
  }))));
};
exports.PopoverPlaceholder = PopoverPlaceholder;