"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExportSettings = void 0;
var _common = require("@kbn/data-plugin/common");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getExportSettings = async (client, config, timezone, logger) => {
  let setTimezone;
  if (timezone) {
    setTimezone = timezone;
  } else {
    // timezone in settings?
    setTimezone = await client.get(_constants.UI_SETTINGS_DATEFORMAT_TZ);
    if (setTimezone === 'Browser') {
      // if `Browser`, hardcode it to 'UTC' so the export has data that makes sense
      logger.warn(`Kibana Advanced Setting "dateFormat:tz" is set to "Browser". Dates will be formatted as UTC to avoid ambiguity.`);
      setTimezone = 'UTC';
    }
  }

  // Advanced Settings that affect search export + CSV
  const [includeFrozen, separator, quoteValues] = await Promise.all([client.get(_constants.UI_SETTINGS_SEARCH_INCLUDE_FROZEN), client.get(_constants.UI_SETTINGS_CSV_SEPARATOR), client.get(_constants.UI_SETTINGS_CSV_QUOTE_VALUES)]);
  const escapeFormulaValues = config.escapeFormulaValues;
  const escapeValue = (0, _common.createEscapeValue)({
    separator,
    quoteValues,
    escapeFormulaValues
  });
  const bom = config.useByteOrderMarkEncoding ? _constants.CSV_BOM_CHARS : '';
  return {
    timezone: setTimezone,
    scroll: {
      size: config.scroll.size,
      duration: config.scroll.duration
    },
    bom,
    includeFrozen,
    separator,
    maxSizeBytes: config.maxSizeBytes,
    checkForFormulas: config.checkForFormulas,
    escapeFormulaValues,
    escapeValue,
    maxConcurrentShardRequests: config.maxConcurrentShardRequests
  };
};
exports.getExportSettings = getExportSettings;