"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorMessage = exports.RotateKeyPairSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorMessage = 'Warning: this API will cause a key pair to rotate and should not be necessary in normal operation.  If you proceed, you may need to reinstall Agents in your network. You must acknowledge the risks of rotating the key pair with acknowledge=true in the request parameters.  For more information, reach out to your administrator.';
exports.errorMessage = errorMessage;
const RotateKeyPairSchema = {
  query: _configSchema.schema.maybe(_configSchema.schema.object({
    acknowledge: _configSchema.schema.boolean({
      defaultValue: false
    })
  }, {
    defaultValue: {
      acknowledge: false
    },
    validate: value => {
      if (!value || !value.acknowledge) {
        throw new Error(errorMessage);
      }
    }
  }))
};
exports.RotateKeyPairSchema = RotateKeyPairSchema;