"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkForRegistryNamingCollision = exports.checkForNamingCollision = exports.checkForInstallationNamingCollision = exports.NamingCollisionError = void 0;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _audit_logging = require("../../../../audit_logging");
var _common = require("../../../../../../common");
var Registry = _interopRequireWildcard(require("../../../registry"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkForNamingCollision = async (savedObjectsClient, integrationName) => {
  await checkForRegistryNamingCollision(savedObjectsClient, integrationName);
  await checkForInstallationNamingCollision(savedObjectsClient, integrationName);
};
exports.checkForNamingCollision = checkForNamingCollision;
const checkForRegistryNamingCollision = async (savedObjectsClient, integrationName) => {
  const registryOrBundledPackage = await Registry.fetchFindLatestPackageOrUndefined(integrationName);
  if (registryOrBundledPackage) {
    const registryConflictMessage = _i18n.i18n.translate('xpack.fleet.customIntegrations.namingCollisionError.registryOrBundle', {
      defaultMessage: 'Failed to create the integration as an integration with the name {integrationName} already exists in the package registry or as a bundled package.',
      values: {
        integrationName
      }
    });
    throw new NamingCollisionError(registryConflictMessage);
  }
};
exports.checkForRegistryNamingCollision = checkForRegistryNamingCollision;
const checkForInstallationNamingCollision = async (savedObjectsClient, integrationName) => {
  const result = await savedObjectsClient.find({
    type: _common.PACKAGES_SAVED_OBJECT_TYPE,
    perPage: 1,
    filter: _esQuery.nodeBuilder.and([_esQuery.nodeBuilder.is(`${_common.PACKAGES_SAVED_OBJECT_TYPE}.attributes.name`, integrationName)])
  });
  if (result.saved_objects.length > 0) {
    const installationConflictMessage = _i18n.i18n.translate('xpack.fleet.customIntegrations.namingCollisionError.installationConflictMessage', {
      defaultMessage: 'Failed to create the integration as an installation with the name {integrationName} already exists.',
      values: {
        integrationName
      }
    });
    throw new NamingCollisionError(installationConflictMessage);
  }
  for (const savedObject of result.saved_objects) {
    _audit_logging.auditLoggingService.writeCustomSoAuditLog({
      action: 'find',
      id: savedObject.id,
      savedObjectType: _common.PACKAGES_SAVED_OBJECT_TYPE
    });
  }
};
exports.checkForInstallationNamingCollision = checkForInstallationNamingCollision;
class NamingCollisionError extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, new.target.prototype);
    this.name = 'NamingCollisionError';
  }
}
exports.NamingCollisionError = NamingCollisionError;